// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    public partial class MaintenanceWindowOptionData : IUtf8JsonSerializable, IJsonModel<MaintenanceWindowOptionData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MaintenanceWindowOptionData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MaintenanceWindowOptionData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MaintenanceWindowOptionData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsCollectionDefined(MaintenanceWindowCycles))
            {
                writer.WritePropertyName("maintenanceWindowCycles"u8);
                writer.WriteStartArray();
                foreach (var item in MaintenanceWindowCycles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(MinDurationInMinutes))
            {
                writer.WritePropertyName("minDurationInMinutes"u8);
                writer.WriteNumberValue(MinDurationInMinutes.Value);
            }
            if (Optional.IsDefined(DefaultDurationInMinutes))
            {
                writer.WritePropertyName("defaultDurationInMinutes"u8);
                writer.WriteNumberValue(DefaultDurationInMinutes.Value);
            }
            if (Optional.IsDefined(MinCycles))
            {
                writer.WritePropertyName("minCycles"u8);
                writer.WriteNumberValue(MinCycles.Value);
            }
            if (Optional.IsDefined(TimeGranularityInMinutes))
            {
                writer.WritePropertyName("timeGranularityInMinutes"u8);
                writer.WriteNumberValue(TimeGranularityInMinutes.Value);
            }
            if (Optional.IsDefined(AllowMultipleMaintenanceWindowsPerCycle))
            {
                writer.WritePropertyName("allowMultipleMaintenanceWindowsPerCycle"u8);
                writer.WriteBooleanValue(AllowMultipleMaintenanceWindowsPerCycle.Value);
            }
            writer.WriteEndObject();
        }

        MaintenanceWindowOptionData IJsonModel<MaintenanceWindowOptionData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MaintenanceWindowOptionData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMaintenanceWindowOptionData(document.RootElement, options);
        }

        internal static MaintenanceWindowOptionData DeserializeMaintenanceWindowOptionData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            bool? isEnabled = default;
            IList<MaintenanceWindowTimeRange> maintenanceWindowCycles = default;
            int? minDurationInMinutes = default;
            int? defaultDurationInMinutes = default;
            int? minCycles = default;
            int? timeGranularityInMinutes = default;
            bool? allowMultipleMaintenanceWindowsPerCycle = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("isEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("maintenanceWindowCycles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<MaintenanceWindowTimeRange> array = new List<MaintenanceWindowTimeRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(MaintenanceWindowTimeRange.DeserializeMaintenanceWindowTimeRange(item, options));
                            }
                            maintenanceWindowCycles = array;
                            continue;
                        }
                        if (property0.NameEquals("minDurationInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minDurationInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("defaultDurationInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            defaultDurationInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("minCycles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minCycles = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("timeGranularityInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            timeGranularityInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("allowMultipleMaintenanceWindowsPerCycle"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowMultipleMaintenanceWindowsPerCycle = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MaintenanceWindowOptionData(
                id,
                name,
                type,
                systemData,
                isEnabled,
                maintenanceWindowCycles ?? new ChangeTrackingList<MaintenanceWindowTimeRange>(),
                minDurationInMinutes,
                defaultDurationInMinutes,
                minCycles,
                timeGranularityInMinutes,
                allowMultipleMaintenanceWindowsPerCycle,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isEnabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsEnabled))
                {
                    builder.Append("    isEnabled: ");
                    var boolValue = IsEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaintenanceWindowCycles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    maintenanceWindowCycles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(MaintenanceWindowCycles))
                {
                    if (MaintenanceWindowCycles.Any())
                    {
                        builder.Append("    maintenanceWindowCycles: ");
                        builder.AppendLine("[");
                        foreach (var item in MaintenanceWindowCycles)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    maintenanceWindowCycles: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinDurationInMinutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    minDurationInMinutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinDurationInMinutes))
                {
                    builder.Append("    minDurationInMinutes: ");
                    builder.AppendLine($"{MinDurationInMinutes.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultDurationInMinutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    defaultDurationInMinutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultDurationInMinutes))
                {
                    builder.Append("    defaultDurationInMinutes: ");
                    builder.AppendLine($"{DefaultDurationInMinutes.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinCycles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    minCycles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinCycles))
                {
                    builder.Append("    minCycles: ");
                    builder.AppendLine($"{MinCycles.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TimeGranularityInMinutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    timeGranularityInMinutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TimeGranularityInMinutes))
                {
                    builder.Append("    timeGranularityInMinutes: ");
                    builder.AppendLine($"{TimeGranularityInMinutes.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowMultipleMaintenanceWindowsPerCycle), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    allowMultipleMaintenanceWindowsPerCycle: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AllowMultipleMaintenanceWindowsPerCycle))
                {
                    builder.Append("    allowMultipleMaintenanceWindowsPerCycle: ");
                    var boolValue = AllowMultipleMaintenanceWindowsPerCycle.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MaintenanceWindowOptionData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MaintenanceWindowOptionData)} does not support writing '{options.Format}' format.");
            }
        }

        MaintenanceWindowOptionData IPersistableModel<MaintenanceWindowOptionData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMaintenanceWindowOptionData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MaintenanceWindowOptionData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MaintenanceWindowOptionData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
