// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the LongTermRetentionBackup data model.
    /// A long term retention backup.
    /// </summary>
    public partial class LongTermRetentionBackupData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LongTermRetentionBackupData"/>. </summary>
        public LongTermRetentionBackupData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LongTermRetentionBackupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverName"> The server name that the backup database belong to. </param>
        /// <param name="serverCreateOn"> The create time of the server. </param>
        /// <param name="databaseName"> The name of the database the backup belong to. </param>
        /// <param name="databaseDeletedOn"> The delete time of the database. </param>
        /// <param name="backupOn"> The time the backup was taken. </param>
        /// <param name="backupExpireOn"> The time the long term retention backup will expire. </param>
        /// <param name="backupStorageRedundancy"> The storage redundancy type of the backup. </param>
        /// <param name="requestedBackupStorageRedundancy"> The storage redundancy type of the backup. </param>
        /// <param name="isBackupImmutable"> The setting whether the LTR backup is immutable. </param>
        /// <param name="backupStorageAccessTier"> The BackupStorageAccessTier for the LTR backup. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LongTermRetentionBackupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string serverName, DateTimeOffset? serverCreateOn, string databaseName, DateTimeOffset? databaseDeletedOn, DateTimeOffset? backupOn, DateTimeOffset? backupExpireOn, SqlBackupStorageRedundancy? backupStorageRedundancy, SqlBackupStorageRedundancy? requestedBackupStorageRedundancy, bool? isBackupImmutable, SqlBackupStorageAccessTier? backupStorageAccessTier, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ServerName = serverName;
            ServerCreateOn = serverCreateOn;
            DatabaseName = databaseName;
            DatabaseDeletedOn = databaseDeletedOn;
            BackupOn = backupOn;
            BackupExpireOn = backupExpireOn;
            BackupStorageRedundancy = backupStorageRedundancy;
            RequestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
            IsBackupImmutable = isBackupImmutable;
            BackupStorageAccessTier = backupStorageAccessTier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The server name that the backup database belong to. </summary>
        [WirePath("properties.serverName")]
        public string ServerName { get; }
        /// <summary> The create time of the server. </summary>
        [WirePath("properties.serverCreateTime")]
        public DateTimeOffset? ServerCreateOn { get; }
        /// <summary> The name of the database the backup belong to. </summary>
        [WirePath("properties.databaseName")]
        public string DatabaseName { get; }
        /// <summary> The delete time of the database. </summary>
        [WirePath("properties.databaseDeletionTime")]
        public DateTimeOffset? DatabaseDeletedOn { get; }
        /// <summary> The time the backup was taken. </summary>
        [WirePath("properties.backupTime")]
        public DateTimeOffset? BackupOn { get; }
        /// <summary> The time the long term retention backup will expire. </summary>
        [WirePath("properties.backupExpirationTime")]
        public DateTimeOffset? BackupExpireOn { get; }
        /// <summary> The storage redundancy type of the backup. </summary>
        [WirePath("properties.backupStorageRedundancy")]
        public SqlBackupStorageRedundancy? BackupStorageRedundancy { get; }
        /// <summary> The storage redundancy type of the backup. </summary>
        [WirePath("properties.requestedBackupStorageRedundancy")]
        public SqlBackupStorageRedundancy? RequestedBackupStorageRedundancy { get; set; }
        /// <summary> The setting whether the LTR backup is immutable. </summary>
        [WirePath("properties.isBackupImmutable")]
        public bool? IsBackupImmutable { get; set; }
        /// <summary> The BackupStorageAccessTier for the LTR backup. </summary>
        [WirePath("properties.backupStorageAccessTier")]
        public SqlBackupStorageAccessTier? BackupStorageAccessTier { get; }
    }
}
