// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class WorkloadGroupOperationSource : IOperationSource<WorkloadGroupResource>
    {
        private readonly ArmClient _client;

        internal WorkloadGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        WorkloadGroupResource IOperationSource<WorkloadGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = WorkloadGroupData.DeserializeWorkloadGroupData(document.RootElement);
            return new WorkloadGroupResource(_client, data);
        }

        async ValueTask<WorkloadGroupResource> IOperationSource<WorkloadGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = WorkloadGroupData.DeserializeWorkloadGroupData(document.RootElement);
            return new WorkloadGroupResource(_client, data);
        }
    }
}
