// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SyncMemberOperationSource : IOperationSource<SyncMemberResource>
    {
        private readonly ArmClient _client;

        internal SyncMemberOperationSource(ArmClient client)
        {
            _client = client;
        }

        SyncMemberResource IOperationSource<SyncMemberResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SyncMemberData.DeserializeSyncMemberData(document.RootElement);
            return new SyncMemberResource(_client, data);
        }

        async ValueTask<SyncMemberResource> IOperationSource<SyncMemberResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SyncMemberData.DeserializeSyncMemberData(document.RootElement);
            return new SyncMemberResource(_client, data);
        }
    }
}
