// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SyncGroupOperationSource : IOperationSource<SyncGroupResource>
    {
        private readonly ArmClient _client;

        internal SyncGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        SyncGroupResource IOperationSource<SyncGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SyncGroupData.DeserializeSyncGroupData(document.RootElement);
            return new SyncGroupResource(_client, data);
        }

        async ValueTask<SyncGroupResource> IOperationSource<SyncGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SyncGroupData.DeserializeSyncGroupData(document.RootElement);
            return new SyncGroupResource(_client, data);
        }
    }
}
