// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SyncAgentOperationSource : IOperationSource<SyncAgentResource>
    {
        private readonly ArmClient _client;

        internal SyncAgentOperationSource(ArmClient client)
        {
            _client = client;
        }

        SyncAgentResource IOperationSource<SyncAgentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SyncAgentData.DeserializeSyncAgentData(document.RootElement);
            return new SyncAgentResource(_client, data);
        }

        async ValueTask<SyncAgentResource> IOperationSource<SyncAgentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SyncAgentData.DeserializeSyncAgentData(document.RootElement);
            return new SyncAgentResource(_client, data);
        }
    }
}
