// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SubscriptionLongTermRetentionBackupOperationSource : IOperationSource<SubscriptionLongTermRetentionBackupResource>
    {
        private readonly ArmClient _client;

        internal SubscriptionLongTermRetentionBackupOperationSource(ArmClient client)
        {
            _client = client;
        }

        SubscriptionLongTermRetentionBackupResource IOperationSource<SubscriptionLongTermRetentionBackupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LongTermRetentionBackupData.DeserializeLongTermRetentionBackupData(document.RootElement);
            return new SubscriptionLongTermRetentionBackupResource(_client, data);
        }

        async ValueTask<SubscriptionLongTermRetentionBackupResource> IOperationSource<SubscriptionLongTermRetentionBackupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LongTermRetentionBackupData.DeserializeLongTermRetentionBackupData(document.RootElement);
            return new SubscriptionLongTermRetentionBackupResource(_client, data);
        }
    }
}
