// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerSecurityAlertPolicyOperationSource : IOperationSource<SqlServerSecurityAlertPolicyResource>
    {
        private readonly ArmClient _client;

        internal SqlServerSecurityAlertPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerSecurityAlertPolicyResource IOperationSource<SqlServerSecurityAlertPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerSecurityAlertPolicyData.DeserializeSqlServerSecurityAlertPolicyData(document.RootElement);
            return new SqlServerSecurityAlertPolicyResource(_client, data);
        }

        async ValueTask<SqlServerSecurityAlertPolicyResource> IOperationSource<SqlServerSecurityAlertPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerSecurityAlertPolicyData.DeserializeSqlServerSecurityAlertPolicyData(document.RootElement);
            return new SqlServerSecurityAlertPolicyResource(_client, data);
        }
    }
}
