// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerOperationSource : IOperationSource<SqlServerResource>
    {
        private readonly ArmClient _client;

        internal SqlServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerResource IOperationSource<SqlServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerData.DeserializeSqlServerData(document.RootElement);
            return new SqlServerResource(_client, data);
        }

        async ValueTask<SqlServerResource> IOperationSource<SqlServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerData.DeserializeSqlServerData(document.RootElement);
            return new SqlServerResource(_client, data);
        }
    }
}
