// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerKeyOperationSource : IOperationSource<SqlServerKeyResource>
    {
        private readonly ArmClient _client;

        internal SqlServerKeyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerKeyResource IOperationSource<SqlServerKeyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerKeyData.DeserializeSqlServerKeyData(document.RootElement);
            return new SqlServerKeyResource(_client, data);
        }

        async ValueTask<SqlServerKeyResource> IOperationSource<SqlServerKeyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerKeyData.DeserializeSqlServerKeyData(document.RootElement);
            return new SqlServerKeyResource(_client, data);
        }
    }
}
