// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerJobExecutionOperationSource : IOperationSource<SqlServerJobExecutionResource>
    {
        private readonly ArmClient _client;

        internal SqlServerJobExecutionOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerJobExecutionResource IOperationSource<SqlServerJobExecutionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerJobExecutionData.DeserializeSqlServerJobExecutionData(document.RootElement);
            return new SqlServerJobExecutionResource(_client, data);
        }

        async ValueTask<SqlServerJobExecutionResource> IOperationSource<SqlServerJobExecutionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerJobExecutionData.DeserializeSqlServerJobExecutionData(document.RootElement);
            return new SqlServerJobExecutionResource(_client, data);
        }
    }
}
