// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerJobAgentOperationSource : IOperationSource<SqlServerJobAgentResource>
    {
        private readonly ArmClient _client;

        internal SqlServerJobAgentOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerJobAgentResource IOperationSource<SqlServerJobAgentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerJobAgentData.DeserializeSqlServerJobAgentData(document.RootElement);
            return new SqlServerJobAgentResource(_client, data);
        }

        async ValueTask<SqlServerJobAgentResource> IOperationSource<SqlServerJobAgentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerJobAgentData.DeserializeSqlServerJobAgentData(document.RootElement);
            return new SqlServerJobAgentResource(_client, data);
        }
    }
}
