// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerDatabaseReplicationLinkOperationSource : IOperationSource<SqlServerDatabaseReplicationLinkResource>
    {
        private readonly ArmClient _client;

        internal SqlServerDatabaseReplicationLinkOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerDatabaseReplicationLinkResource IOperationSource<SqlServerDatabaseReplicationLinkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerDatabaseReplicationLinkData.DeserializeSqlServerDatabaseReplicationLinkData(document.RootElement);
            return new SqlServerDatabaseReplicationLinkResource(_client, data);
        }

        async ValueTask<SqlServerDatabaseReplicationLinkResource> IOperationSource<SqlServerDatabaseReplicationLinkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerDatabaseReplicationLinkData.DeserializeSqlServerDatabaseReplicationLinkData(document.RootElement);
            return new SqlServerDatabaseReplicationLinkResource(_client, data);
        }
    }
}
