// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerConnectionPolicyOperationSource : IOperationSource<SqlServerConnectionPolicyResource>
    {
        private readonly ArmClient _client;

        internal SqlServerConnectionPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerConnectionPolicyResource IOperationSource<SqlServerConnectionPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerConnectionPolicyData.DeserializeSqlServerConnectionPolicyData(document.RootElement);
            return new SqlServerConnectionPolicyResource(_client, data);
        }

        async ValueTask<SqlServerConnectionPolicyResource> IOperationSource<SqlServerConnectionPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerConnectionPolicyData.DeserializeSqlServerConnectionPolicyData(document.RootElement);
            return new SqlServerConnectionPolicyResource(_client, data);
        }
    }
}
