// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class SqlServerCommunicationLinkOperationSource : IOperationSource<SqlServerCommunicationLinkResource>
    {
        private readonly ArmClient _client;

        internal SqlServerCommunicationLinkOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlServerCommunicationLinkResource IOperationSource<SqlServerCommunicationLinkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlServerCommunicationLinkData.DeserializeSqlServerCommunicationLinkData(document.RootElement);
            return new SqlServerCommunicationLinkResource(_client, data);
        }

        async ValueTask<SqlServerCommunicationLinkResource> IOperationSource<SqlServerCommunicationLinkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlServerCommunicationLinkData.DeserializeSqlServerCommunicationLinkData(document.RootElement);
            return new SqlServerCommunicationLinkResource(_client, data);
        }
    }
}
