// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedServerSecurityAlertPolicyOperationSource : IOperationSource<ManagedServerSecurityAlertPolicyResource>
    {
        private readonly ArmClient _client;

        internal ManagedServerSecurityAlertPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedServerSecurityAlertPolicyResource IOperationSource<ManagedServerSecurityAlertPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedServerSecurityAlertPolicyData.DeserializeManagedServerSecurityAlertPolicyData(document.RootElement);
            return new ManagedServerSecurityAlertPolicyResource(_client, data);
        }

        async ValueTask<ManagedServerSecurityAlertPolicyResource> IOperationSource<ManagedServerSecurityAlertPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedServerSecurityAlertPolicyData.DeserializeManagedServerSecurityAlertPolicyData(document.RootElement);
            return new ManagedServerSecurityAlertPolicyResource(_client, data);
        }
    }
}
