// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedServerDnsAliasOperationSource : IOperationSource<ManagedServerDnsAliasResource>
    {
        private readonly ArmClient _client;

        internal ManagedServerDnsAliasOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedServerDnsAliasResource IOperationSource<ManagedServerDnsAliasResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedServerDnsAliasData.DeserializeManagedServerDnsAliasData(document.RootElement);
            return new ManagedServerDnsAliasResource(_client, data);
        }

        async ValueTask<ManagedServerDnsAliasResource> IOperationSource<ManagedServerDnsAliasResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedServerDnsAliasData.DeserializeManagedServerDnsAliasData(document.RootElement);
            return new ManagedServerDnsAliasResource(_client, data);
        }
    }
}
