// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedLedgerDigestUploadOperationSource : IOperationSource<ManagedLedgerDigestUploadResource>
    {
        private readonly ArmClient _client;

        internal ManagedLedgerDigestUploadOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedLedgerDigestUploadResource IOperationSource<ManagedLedgerDigestUploadResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedLedgerDigestUploadData.DeserializeManagedLedgerDigestUploadData(document.RootElement);
            return new ManagedLedgerDigestUploadResource(_client, data);
        }

        async ValueTask<ManagedLedgerDigestUploadResource> IOperationSource<ManagedLedgerDigestUploadResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedLedgerDigestUploadData.DeserializeManagedLedgerDigestUploadData(document.RootElement);
            return new ManagedLedgerDigestUploadResource(_client, data);
        }
    }
}
