// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceServerTrustCertificateOperationSource : IOperationSource<ManagedInstanceServerTrustCertificateResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceServerTrustCertificateOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceServerTrustCertificateResource IOperationSource<ManagedInstanceServerTrustCertificateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServerTrustCertificateData.DeserializeServerTrustCertificateData(document.RootElement);
            return new ManagedInstanceServerTrustCertificateResource(_client, data);
        }

        async ValueTask<ManagedInstanceServerTrustCertificateResource> IOperationSource<ManagedInstanceServerTrustCertificateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServerTrustCertificateData.DeserializeServerTrustCertificateData(document.RootElement);
            return new ManagedInstanceServerTrustCertificateResource(_client, data);
        }
    }
}
