// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceServerConfigurationOptionOperationSource : IOperationSource<ManagedInstanceServerConfigurationOptionResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceServerConfigurationOptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceServerConfigurationOptionResource IOperationSource<ManagedInstanceServerConfigurationOptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceServerConfigurationOptionData.DeserializeManagedInstanceServerConfigurationOptionData(document.RootElement);
            return new ManagedInstanceServerConfigurationOptionResource(_client, data);
        }

        async ValueTask<ManagedInstanceServerConfigurationOptionResource> IOperationSource<ManagedInstanceServerConfigurationOptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceServerConfigurationOptionData.DeserializeManagedInstanceServerConfigurationOptionData(document.RootElement);
            return new ManagedInstanceServerConfigurationOptionResource(_client, data);
        }
    }
}
