// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceOperationSource : IOperationSource<ManagedInstanceResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceResource IOperationSource<ManagedInstanceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceData.DeserializeManagedInstanceData(document.RootElement);
            return new ManagedInstanceResource(_client, data);
        }

        async ValueTask<ManagedInstanceResource> IOperationSource<ManagedInstanceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceData.DeserializeManagedInstanceData(document.RootElement);
            return new ManagedInstanceResource(_client, data);
        }
    }
}
