// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceLongTermRetentionPolicyOperationSource : IOperationSource<ManagedInstanceLongTermRetentionPolicyResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceLongTermRetentionPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceLongTermRetentionPolicyResource IOperationSource<ManagedInstanceLongTermRetentionPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceLongTermRetentionPolicyData.DeserializeManagedInstanceLongTermRetentionPolicyData(document.RootElement);
            return new ManagedInstanceLongTermRetentionPolicyResource(_client, data);
        }

        async ValueTask<ManagedInstanceLongTermRetentionPolicyResource> IOperationSource<ManagedInstanceLongTermRetentionPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceLongTermRetentionPolicyData.DeserializeManagedInstanceLongTermRetentionPolicyData(document.RootElement);
            return new ManagedInstanceLongTermRetentionPolicyResource(_client, data);
        }
    }
}
