// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceKeyOperationSource : IOperationSource<ManagedInstanceKeyResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceKeyOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceKeyResource IOperationSource<ManagedInstanceKeyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceKeyData.DeserializeManagedInstanceKeyData(document.RootElement);
            return new ManagedInstanceKeyResource(_client, data);
        }

        async ValueTask<ManagedInstanceKeyResource> IOperationSource<ManagedInstanceKeyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceKeyData.DeserializeManagedInstanceKeyData(document.RootElement);
            return new ManagedInstanceKeyResource(_client, data);
        }
    }
}
