// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceDtcOperationSource : IOperationSource<ManagedInstanceDtcResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceDtcOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceDtcResource IOperationSource<ManagedInstanceDtcResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceDtcData.DeserializeManagedInstanceDtcData(document.RootElement);
            return new ManagedInstanceDtcResource(_client, data);
        }

        async ValueTask<ManagedInstanceDtcResource> IOperationSource<ManagedInstanceDtcResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceDtcData.DeserializeManagedInstanceDtcData(document.RootElement);
            return new ManagedInstanceDtcResource(_client, data);
        }
    }
}
