// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ManagedInstanceAdvancedThreatProtectionOperationSource : IOperationSource<ManagedInstanceAdvancedThreatProtectionResource>
    {
        private readonly ArmClient _client;

        internal ManagedInstanceAdvancedThreatProtectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedInstanceAdvancedThreatProtectionResource IOperationSource<ManagedInstanceAdvancedThreatProtectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedInstanceAdvancedThreatProtectionData.DeserializeManagedInstanceAdvancedThreatProtectionData(document.RootElement);
            return new ManagedInstanceAdvancedThreatProtectionResource(_client, data);
        }

        async ValueTask<ManagedInstanceAdvancedThreatProtectionResource> IOperationSource<ManagedInstanceAdvancedThreatProtectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedInstanceAdvancedThreatProtectionData.DeserializeManagedInstanceAdvancedThreatProtectionData(document.RootElement);
            return new ManagedInstanceAdvancedThreatProtectionResource(_client, data);
        }
    }
}
