// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class LogicalDatabaseTransparentDataEncryptionOperationSource : IOperationSource<LogicalDatabaseTransparentDataEncryptionResource>
    {
        private readonly ArmClient _client;

        internal LogicalDatabaseTransparentDataEncryptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        LogicalDatabaseTransparentDataEncryptionResource IOperationSource<LogicalDatabaseTransparentDataEncryptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LogicalDatabaseTransparentDataEncryptionData.DeserializeLogicalDatabaseTransparentDataEncryptionData(document.RootElement);
            return new LogicalDatabaseTransparentDataEncryptionResource(_client, data);
        }

        async ValueTask<LogicalDatabaseTransparentDataEncryptionResource> IOperationSource<LogicalDatabaseTransparentDataEncryptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LogicalDatabaseTransparentDataEncryptionData.DeserializeLogicalDatabaseTransparentDataEncryptionData(document.RootElement);
            return new LogicalDatabaseTransparentDataEncryptionResource(_client, data);
        }
    }
}
