// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    internal class ImportExportExtensionsOperationResultOperationSource : IOperationSource<ImportExportExtensionsOperationResult>
    {
        ImportExportExtensionsOperationResult IOperationSource<ImportExportExtensionsOperationResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ImportExportExtensionsOperationResult.DeserializeImportExportExtensionsOperationResult(document.RootElement);
        }

        async ValueTask<ImportExportExtensionsOperationResult> IOperationSource<ImportExportExtensionsOperationResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ImportExportExtensionsOperationResult.DeserializeImportExportExtensionsOperationResult(document.RootElement);
        }
    }
}
