// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class EncryptionProtectorOperationSource : IOperationSource<EncryptionProtectorResource>
    {
        private readonly ArmClient _client;

        internal EncryptionProtectorOperationSource(ArmClient client)
        {
            _client = client;
        }

        EncryptionProtectorResource IOperationSource<EncryptionProtectorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EncryptionProtectorData.DeserializeEncryptionProtectorData(document.RootElement);
            return new EncryptionProtectorResource(_client, data);
        }

        async ValueTask<EncryptionProtectorResource> IOperationSource<EncryptionProtectorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EncryptionProtectorData.DeserializeEncryptionProtectorData(document.RootElement);
            return new EncryptionProtectorResource(_client, data);
        }
    }
}
