// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class ElasticPoolOperationSource : IOperationSource<ElasticPoolResource>
    {
        private readonly ArmClient _client;

        internal ElasticPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        ElasticPoolResource IOperationSource<ElasticPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ElasticPoolData.DeserializeElasticPoolData(document.RootElement);
            return new ElasticPoolResource(_client, data);
        }

        async ValueTask<ElasticPoolResource> IOperationSource<ElasticPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ElasticPoolData.DeserializeElasticPoolData(document.RootElement);
            return new ElasticPoolResource(_client, data);
        }
    }
}
