// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class DistributedAvailabilityGroupOperationSource : IOperationSource<DistributedAvailabilityGroupResource>
    {
        private readonly ArmClient _client;

        internal DistributedAvailabilityGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        DistributedAvailabilityGroupResource IOperationSource<DistributedAvailabilityGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DistributedAvailabilityGroupData.DeserializeDistributedAvailabilityGroupData(document.RootElement);
            return new DistributedAvailabilityGroupResource(_client, data);
        }

        async ValueTask<DistributedAvailabilityGroupResource> IOperationSource<DistributedAvailabilityGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DistributedAvailabilityGroupData.DeserializeDistributedAvailabilityGroupData(document.RootElement);
            return new DistributedAvailabilityGroupResource(_client, data);
        }
    }
}
