// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sql
{
    internal class DeletedServerOperationSource : IOperationSource<DeletedServerResource>
    {
        private readonly ArmClient _client;

        internal DeletedServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeletedServerResource IOperationSource<DeletedServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeletedServerData.DeserializeDeletedServerData(document.RootElement);
            return new DeletedServerResource(_client, data);
        }

        async ValueTask<DeletedServerResource> IOperationSource<DeletedServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeletedServerData.DeserializeDeletedServerData(document.RootElement);
            return new DeletedServerResource(_client, data);
        }
    }
}
