// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the InstanceFailoverGroup data model.
    /// An instance failover group.
    /// </summary>
    public partial class InstanceFailoverGroupData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstanceFailoverGroupData"/>. </summary>
        public InstanceFailoverGroupData()
        {
            PartnerRegions = new ChangeTrackingList<PartnerRegionInfo>();
            ManagedInstancePairs = new ChangeTrackingList<ManagedInstancePairInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="InstanceFailoverGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="secondaryType"> Type of the geo-secondary instance. Set 'Standby' if the instance is used as a DR option only. </param>
        /// <param name="readWriteEndpoint"> Read-write endpoint of the failover group instance. </param>
        /// <param name="readOnlyEndpoint"> Read-only endpoint of the failover group instance. </param>
        /// <param name="replicationRole"> Local replication role of the failover group instance. </param>
        /// <param name="replicationState"> Replication state of the failover group instance. </param>
        /// <param name="partnerRegions"> Partner region information for the failover group. </param>
        /// <param name="managedInstancePairs"> List of managed instance pairs in the failover group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstanceFailoverGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, GeoSecondaryInstanceType? secondaryType, InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint, InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint, InstanceFailoverGroupReplicationRole? replicationRole, string replicationState, IList<PartnerRegionInfo> partnerRegions, IList<ManagedInstancePairInfo> managedInstancePairs, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SecondaryType = secondaryType;
            ReadWriteEndpoint = readWriteEndpoint;
            ReadOnlyEndpoint = readOnlyEndpoint;
            ReplicationRole = replicationRole;
            ReplicationState = replicationState;
            PartnerRegions = partnerRegions;
            ManagedInstancePairs = managedInstancePairs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the geo-secondary instance. Set 'Standby' if the instance is used as a DR option only. </summary>
        [WirePath("properties.secondaryType")]
        public GeoSecondaryInstanceType? SecondaryType { get; set; }
        /// <summary> Read-write endpoint of the failover group instance. </summary>
        [WirePath("properties.readWriteEndpoint")]
        public InstanceFailoverGroupReadWriteEndpoint ReadWriteEndpoint { get; set; }
        /// <summary> Read-only endpoint of the failover group instance. </summary>
        internal InstanceFailoverGroupReadOnlyEndpoint ReadOnlyEndpoint { get; set; }
        /// <summary> Failover policy of the read-only endpoint for the failover group. </summary>
        [WirePath("properties.readOnlyEndpoint.failoverPolicy")]
        public ReadOnlyEndpointFailoverPolicy? ReadOnlyEndpointFailoverPolicy
        {
            get => ReadOnlyEndpoint is null ? default : ReadOnlyEndpoint.FailoverPolicy;
            set
            {
                if (ReadOnlyEndpoint is null)
                    ReadOnlyEndpoint = new InstanceFailoverGroupReadOnlyEndpoint();
                ReadOnlyEndpoint.FailoverPolicy = value;
            }
        }

        /// <summary> Local replication role of the failover group instance. </summary>
        [WirePath("properties.replicationRole")]
        public InstanceFailoverGroupReplicationRole? ReplicationRole { get; }
        /// <summary> Replication state of the failover group instance. </summary>
        [WirePath("properties.replicationState")]
        public string ReplicationState { get; }
        /// <summary> Partner region information for the failover group. </summary>
        [WirePath("properties.partnerRegions")]
        public IList<PartnerRegionInfo> PartnerRegions { get; }
        /// <summary> List of managed instance pairs in the failover group. </summary>
        [WirePath("properties.managedInstancePairs")]
        public IList<ManagedInstancePairInfo> ManagedInstancePairs { get; }
    }
}
