// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Sql.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSqlArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSqlArmClient"/> class for mocking. </summary>
        protected MockableSqlArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSqlArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSqlArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSqlArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataMaskingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataMaskingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="DataMaskingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataMaskingPolicyResource"/> object. </returns>
        public virtual DataMaskingPolicyResource GetDataMaskingPolicyResource(ResourceIdentifier id)
        {
            DataMaskingPolicyResource.ValidateResourceId(id);
            return new DataMaskingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GeoBackupPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GeoBackupPolicyResource.CreateResourceIdentifier" /> to create a <see cref="GeoBackupPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GeoBackupPolicyResource"/> object. </returns>
        public virtual GeoBackupPolicyResource GetGeoBackupPolicyResource(ResourceIdentifier id)
        {
            GeoBackupPolicyResource.ValidateResourceId(id);
            return new GeoBackupPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerCommunicationLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerCommunicationLinkResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerCommunicationLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerCommunicationLinkResource"/> object. </returns>
        public virtual SqlServerCommunicationLinkResource GetSqlServerCommunicationLinkResource(ResourceIdentifier id)
        {
            SqlServerCommunicationLinkResource.ValidateResourceId(id);
            return new SqlServerCommunicationLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceObjectiveResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceObjectiveResource.CreateResourceIdentifier" /> to create a <see cref="ServiceObjectiveResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceObjectiveResource"/> object. </returns>
        public virtual ServiceObjectiveResource GetServiceObjectiveResource(ResourceIdentifier id)
        {
            ServiceObjectiveResource.ValidateResourceId(id);
            return new ServiceObjectiveResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseAdvisorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseAdvisorResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseAdvisorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseAdvisorResource"/> object. </returns>
        public virtual SqlDatabaseAdvisorResource GetSqlDatabaseAdvisorResource(ResourceIdentifier id)
        {
            SqlDatabaseAdvisorResource.ValidateResourceId(id);
            return new SqlDatabaseAdvisorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerAdvisorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerAdvisorResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerAdvisorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerAdvisorResource"/> object. </returns>
        public virtual SqlServerAdvisorResource GetSqlServerAdvisorResource(ResourceIdentifier id)
        {
            SqlServerAdvisorResource.ValidateResourceId(id);
            return new SqlServerAdvisorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseAutomaticTuningResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseAutomaticTuningResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseAutomaticTuningResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseAutomaticTuningResource"/> object. </returns>
        public virtual SqlDatabaseAutomaticTuningResource GetSqlDatabaseAutomaticTuningResource(ResourceIdentifier id)
        {
            SqlDatabaseAutomaticTuningResource.ValidateResourceId(id);
            return new SqlDatabaseAutomaticTuningResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseColumnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseColumnResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseColumnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseColumnResource"/> object. </returns>
        public virtual SqlDatabaseColumnResource GetSqlDatabaseColumnResource(ResourceIdentifier id)
        {
            SqlDatabaseColumnResource.ValidateResourceId(id);
            return new SqlDatabaseColumnResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseColumnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseColumnResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseColumnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseColumnResource"/> object. </returns>
        public virtual ManagedDatabaseColumnResource GetManagedDatabaseColumnResource(ResourceIdentifier id)
        {
            ManagedDatabaseColumnResource.ValidateResourceId(id);
            return new ManagedDatabaseColumnResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RecommendedActionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RecommendedActionResource.CreateResourceIdentifier" /> to create a <see cref="RecommendedActionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RecommendedActionResource"/> object. </returns>
        public virtual RecommendedActionResource GetRecommendedActionResource(ResourceIdentifier id)
        {
            RecommendedActionResource.ValidateResourceId(id);
            return new RecommendedActionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSchemaResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSchemaResource"/> object. </returns>
        public virtual SqlDatabaseSchemaResource GetSqlDatabaseSchemaResource(ResourceIdentifier id)
        {
            SqlDatabaseSchemaResource.ValidateResourceId(id);
            return new SqlDatabaseSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseSchemaResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseSchemaResource"/> object. </returns>
        public virtual ManagedDatabaseSchemaResource GetManagedDatabaseSchemaResource(ResourceIdentifier id)
        {
            ManagedDatabaseSchemaResource.ValidateResourceId(id);
            return new ManagedDatabaseSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSecurityAlertPolicyResource"/> object. </returns>
        public virtual SqlDatabaseSecurityAlertPolicyResource GetSqlDatabaseSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            SqlDatabaseSecurityAlertPolicyResource.ValidateResourceId(id);
            return new SqlDatabaseSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseTableResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseTableResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseTableResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseTableResource"/> object. </returns>
        public virtual SqlDatabaseTableResource GetSqlDatabaseTableResource(ResourceIdentifier id)
        {
            SqlDatabaseTableResource.ValidateResourceId(id);
            return new SqlDatabaseTableResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseTableResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseTableResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseTableResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseTableResource"/> object. </returns>
        public virtual ManagedDatabaseTableResource GetManagedDatabaseTableResource(ResourceIdentifier id)
        {
            ManagedDatabaseTableResource.ValidateResourceId(id);
            return new ManagedDatabaseTableResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> object. </returns>
        public virtual SqlDatabaseVulnerabilityAssessmentRuleBaselineResource GetSqlDatabaseVulnerabilityAssessmentRuleBaselineResource(ResourceIdentifier id)
        {
            SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.ValidateResourceId(id);
            return new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource"/> object. </returns>
        public virtual ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResource(ResourceIdentifier id)
        {
            ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource.ValidateResourceId(id);
            return new ManagedDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SqlDatabaseVulnerabilityAssessmentResource GetSqlDatabaseVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SqlDatabaseVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SqlDatabaseVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseVulnerabilityAssessmentResource"/> object. </returns>
        public virtual ManagedDatabaseVulnerabilityAssessmentResource GetManagedDatabaseVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            ManagedDatabaseVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new ManagedDatabaseVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseVulnerabilityAssessmentScanResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> object. </returns>
        public virtual SqlDatabaseVulnerabilityAssessmentScanResource GetSqlDatabaseVulnerabilityAssessmentScanResource(ResourceIdentifier id)
        {
            SqlDatabaseVulnerabilityAssessmentScanResource.ValidateResourceId(id);
            return new SqlDatabaseVulnerabilityAssessmentScanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> object. </returns>
        public virtual ManagedDatabaseVulnerabilityAssessmentScanResource GetManagedDatabaseVulnerabilityAssessmentScanResource(ResourceIdentifier id)
        {
            ManagedDatabaseVulnerabilityAssessmentScanResource.ValidateResourceId(id);
            return new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataWarehouseUserActivityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataWarehouseUserActivityResource.CreateResourceIdentifier" /> to create a <see cref="DataWarehouseUserActivityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataWarehouseUserActivityResource"/> object. </returns>
        public virtual DataWarehouseUserActivityResource GetDataWarehouseUserActivityResource(ResourceIdentifier id)
        {
            DataWarehouseUserActivityResource.ValidateResourceId(id);
            return new DataWarehouseUserActivityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DeletedServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DeletedServerResource.CreateResourceIdentifier" /> to create a <see cref="DeletedServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DeletedServerResource"/> object. </returns>
        public virtual DeletedServerResource GetDeletedServerResource(ResourceIdentifier id)
        {
            DeletedServerResource.ValidateResourceId(id);
            return new DeletedServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="EncryptionProtectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="EncryptionProtectorResource.CreateResourceIdentifier" /> to create an <see cref="EncryptionProtectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="EncryptionProtectorResource"/> object. </returns>
        public virtual EncryptionProtectorResource GetEncryptionProtectorResource(ResourceIdentifier id)
        {
            EncryptionProtectorResource.ValidateResourceId(id);
            return new EncryptionProtectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlFirewallRuleResource.CreateResourceIdentifier" /> to create a <see cref="SqlFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlFirewallRuleResource"/> object. </returns>
        public virtual SqlFirewallRuleResource GetSqlFirewallRuleResource(ResourceIdentifier id)
        {
            SqlFirewallRuleResource.ValidateResourceId(id);
            return new SqlFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobAgentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobAgentResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobAgentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobAgentResource"/> object. </returns>
        public virtual SqlServerJobAgentResource GetSqlServerJobAgentResource(ResourceIdentifier id)
        {
            SqlServerJobAgentResource.ValidateResourceId(id);
            return new SqlServerJobAgentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobCredentialResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobCredentialResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobCredentialResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobCredentialResource"/> object. </returns>
        public virtual SqlServerJobCredentialResource GetSqlServerJobCredentialResource(ResourceIdentifier id)
        {
            SqlServerJobCredentialResource.ValidateResourceId(id);
            return new SqlServerJobCredentialResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobExecutionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobExecutionResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobExecutionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobExecutionResource"/> object. </returns>
        public virtual SqlServerJobExecutionResource GetSqlServerJobExecutionResource(ResourceIdentifier id)
        {
            SqlServerJobExecutionResource.ValidateResourceId(id);
            return new SqlServerJobExecutionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobExecutionStepResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobExecutionStepResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobExecutionStepResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobExecutionStepResource"/> object. </returns>
        public virtual SqlServerJobExecutionStepResource GetSqlServerJobExecutionStepResource(ResourceIdentifier id)
        {
            SqlServerJobExecutionStepResource.ValidateResourceId(id);
            return new SqlServerJobExecutionStepResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobExecutionStepTargetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobExecutionStepTargetResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobExecutionStepTargetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobExecutionStepTargetResource"/> object. </returns>
        public virtual SqlServerJobExecutionStepTargetResource GetSqlServerJobExecutionStepTargetResource(ResourceIdentifier id)
        {
            SqlServerJobExecutionStepTargetResource.ValidateResourceId(id);
            return new SqlServerJobExecutionStepTargetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobResource"/> object. </returns>
        public virtual SqlServerJobResource GetSqlServerJobResource(ResourceIdentifier id)
        {
            SqlServerJobResource.ValidateResourceId(id);
            return new SqlServerJobResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobVersionStepResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobVersionStepResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobVersionStepResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobVersionStepResource"/> object. </returns>
        public virtual SqlServerJobVersionStepResource GetSqlServerJobVersionStepResource(ResourceIdentifier id)
        {
            SqlServerJobVersionStepResource.ValidateResourceId(id);
            return new SqlServerJobVersionStepResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobStepResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobStepResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobStepResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobStepResource"/> object. </returns>
        public virtual SqlServerJobStepResource GetSqlServerJobStepResource(ResourceIdentifier id)
        {
            SqlServerJobStepResource.ValidateResourceId(id);
            return new SqlServerJobStepResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobTargetGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobTargetGroupResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobTargetGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobTargetGroupResource"/> object. </returns>
        public virtual SqlServerJobTargetGroupResource GetSqlServerJobTargetGroupResource(ResourceIdentifier id)
        {
            SqlServerJobTargetGroupResource.ValidateResourceId(id);
            return new SqlServerJobTargetGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerJobVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerJobVersionResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerJobVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerJobVersionResource"/> object. </returns>
        public virtual SqlServerJobVersionResource GetSqlServerJobVersionResource(ResourceIdentifier id)
        {
            SqlServerJobVersionResource.ValidateResourceId(id);
            return new SqlServerJobVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MaintenanceWindowOptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MaintenanceWindowOptionResource.CreateResourceIdentifier" /> to create a <see cref="MaintenanceWindowOptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MaintenanceWindowOptionResource"/> object. </returns>
        public virtual MaintenanceWindowOptionResource GetMaintenanceWindowOptionResource(ResourceIdentifier id)
        {
            MaintenanceWindowOptionResource.ValidateResourceId(id);
            return new MaintenanceWindowOptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MaintenanceWindowsResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MaintenanceWindowsResource.CreateResourceIdentifier" /> to create a <see cref="MaintenanceWindowsResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MaintenanceWindowsResource"/> object. </returns>
        public virtual MaintenanceWindowsResource GetMaintenanceWindowsResource(ResourceIdentifier id)
        {
            MaintenanceWindowsResource.ValidateResourceId(id);
            return new MaintenanceWindowsResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedBackupShortTermRetentionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedBackupShortTermRetentionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedBackupShortTermRetentionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedBackupShortTermRetentionPolicyResource"/> object. </returns>
        public virtual ManagedBackupShortTermRetentionPolicyResource GetManagedBackupShortTermRetentionPolicyResource(ResourceIdentifier id)
        {
            ManagedBackupShortTermRetentionPolicyResource.ValidateResourceId(id);
            return new ManagedBackupShortTermRetentionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource"/> object. </returns>
        public virtual ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource GetManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource(ResourceIdentifier id)
        {
            ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource.ValidateResourceId(id);
            return new ManagedRestorableDroppedDbBackupShortTermRetentionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseSecurityAlertPolicyResource"/> object. </returns>
        public virtual ManagedDatabaseSecurityAlertPolicyResource GetManagedDatabaseSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            ManagedDatabaseSecurityAlertPolicyResource.ValidateResourceId(id);
            return new ManagedDatabaseSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedTransparentDataEncryptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedTransparentDataEncryptionResource.CreateResourceIdentifier" /> to create a <see cref="ManagedTransparentDataEncryptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedTransparentDataEncryptionResource"/> object. </returns>
        public virtual ManagedTransparentDataEncryptionResource GetManagedTransparentDataEncryptionResource(ResourceIdentifier id)
        {
            ManagedTransparentDataEncryptionResource.ValidateResourceId(id);
            return new ManagedTransparentDataEncryptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceAdministratorResource"/> object. </returns>
        public virtual ManagedInstanceAdministratorResource GetManagedInstanceAdministratorResource(ResourceIdentifier id)
        {
            ManagedInstanceAdministratorResource.ValidateResourceId(id);
            return new ManagedInstanceAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceAzureADOnlyAuthenticationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceAzureADOnlyAuthenticationResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceAzureADOnlyAuthenticationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceAzureADOnlyAuthenticationResource"/> object. </returns>
        public virtual ManagedInstanceAzureADOnlyAuthenticationResource GetManagedInstanceAzureADOnlyAuthenticationResource(ResourceIdentifier id)
        {
            ManagedInstanceAzureADOnlyAuthenticationResource.ValidateResourceId(id);
            return new ManagedInstanceAzureADOnlyAuthenticationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceEncryptionProtectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceEncryptionProtectorResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceEncryptionProtectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceEncryptionProtectorResource"/> object. </returns>
        public virtual ManagedInstanceEncryptionProtectorResource GetManagedInstanceEncryptionProtectorResource(ResourceIdentifier id)
        {
            ManagedInstanceEncryptionProtectorResource.ValidateResourceId(id);
            return new ManagedInstanceEncryptionProtectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceKeyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceKeyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceKeyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceKeyResource"/> object. </returns>
        public virtual ManagedInstanceKeyResource GetManagedInstanceKeyResource(ResourceIdentifier id)
        {
            ManagedInstanceKeyResource.ValidateResourceId(id);
            return new ManagedInstanceKeyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceLongTermRetentionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceLongTermRetentionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceLongTermRetentionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceLongTermRetentionPolicyResource"/> object. </returns>
        public virtual ManagedInstanceLongTermRetentionPolicyResource GetManagedInstanceLongTermRetentionPolicyResource(ResourceIdentifier id)
        {
            ManagedInstanceLongTermRetentionPolicyResource.ValidateResourceId(id);
            return new ManagedInstanceLongTermRetentionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceOperationResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceOperationResource"/> object. </returns>
        public virtual ManagedInstanceOperationResource GetManagedInstanceOperationResource(ResourceIdentifier id)
        {
            ManagedInstanceOperationResource.ValidateResourceId(id);
            return new ManagedInstanceOperationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstancePrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstancePrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstancePrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstancePrivateEndpointConnectionResource"/> object. </returns>
        public virtual ManagedInstancePrivateEndpointConnectionResource GetManagedInstancePrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            ManagedInstancePrivateEndpointConnectionResource.ValidateResourceId(id);
            return new ManagedInstancePrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstancePrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstancePrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstancePrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstancePrivateLinkResource"/> object. </returns>
        public virtual ManagedInstancePrivateLinkResource GetManagedInstancePrivateLinkResource(ResourceIdentifier id)
        {
            ManagedInstancePrivateLinkResource.ValidateResourceId(id);
            return new ManagedInstancePrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceVulnerabilityAssessmentResource"/> object. </returns>
        public virtual ManagedInstanceVulnerabilityAssessmentResource GetManagedInstanceVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            ManagedInstanceVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new ManagedInstanceVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedServerSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedServerSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ManagedServerSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedServerSecurityAlertPolicyResource"/> object. </returns>
        public virtual ManagedServerSecurityAlertPolicyResource GetManagedServerSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            ManagedServerSecurityAlertPolicyResource.ValidateResourceId(id);
            return new ManagedServerSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="SqlPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlPrivateEndpointConnectionResource"/> object. </returns>
        public virtual SqlPrivateEndpointConnectionResource GetSqlPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            SqlPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new SqlPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="SqlPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlPrivateLinkResource"/> object. </returns>
        public virtual SqlPrivateLinkResource GetSqlPrivateLinkResource(ResourceIdentifier id)
        {
            SqlPrivateLinkResource.ValidateResourceId(id);
            return new SqlPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RecoverableManagedDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RecoverableManagedDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="RecoverableManagedDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RecoverableManagedDatabaseResource"/> object. </returns>
        public virtual RecoverableManagedDatabaseResource GetRecoverableManagedDatabaseResource(ResourceIdentifier id)
        {
            RecoverableManagedDatabaseResource.ValidateResourceId(id);
            return new RecoverableManagedDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerDatabaseRestorePointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerDatabaseRestorePointResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerDatabaseRestorePointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerDatabaseRestorePointResource"/> object. </returns>
        public virtual SqlServerDatabaseRestorePointResource GetSqlServerDatabaseRestorePointResource(ResourceIdentifier id)
        {
            SqlServerDatabaseRestorePointResource.ValidateResourceId(id);
            return new SqlServerDatabaseRestorePointResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerAutomaticTuningResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerAutomaticTuningResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerAutomaticTuningResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerAutomaticTuningResource"/> object. </returns>
        public virtual SqlServerAutomaticTuningResource GetSqlServerAutomaticTuningResource(ResourceIdentifier id)
        {
            SqlServerAutomaticTuningResource.ValidateResourceId(id);
            return new SqlServerAutomaticTuningResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerAzureADAdministratorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerAzureADAdministratorResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerAzureADAdministratorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerAzureADAdministratorResource"/> object. </returns>
        public virtual SqlServerAzureADAdministratorResource GetSqlServerAzureADAdministratorResource(ResourceIdentifier id)
        {
            SqlServerAzureADAdministratorResource.ValidateResourceId(id);
            return new SqlServerAzureADAdministratorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerAzureADOnlyAuthenticationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerAzureADOnlyAuthenticationResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerAzureADOnlyAuthenticationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerAzureADOnlyAuthenticationResource"/> object. </returns>
        public virtual SqlServerAzureADOnlyAuthenticationResource GetSqlServerAzureADOnlyAuthenticationResource(ResourceIdentifier id)
        {
            SqlServerAzureADOnlyAuthenticationResource.ValidateResourceId(id);
            return new SqlServerAzureADOnlyAuthenticationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerDevOpsAuditingSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerDevOpsAuditingSettingResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerDevOpsAuditingSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerDevOpsAuditingSettingResource"/> object. </returns>
        public virtual SqlServerDevOpsAuditingSettingResource GetSqlServerDevOpsAuditingSettingResource(ResourceIdentifier id)
        {
            SqlServerDevOpsAuditingSettingResource.ValidateResourceId(id);
            return new SqlServerDevOpsAuditingSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerDnsAliasResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerDnsAliasResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerDnsAliasResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerDnsAliasResource"/> object. </returns>
        public virtual SqlServerDnsAliasResource GetSqlServerDnsAliasResource(ResourceIdentifier id)
        {
            SqlServerDnsAliasResource.ValidateResourceId(id);
            return new SqlServerDnsAliasResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerKeyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerKeyResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerKeyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerKeyResource"/> object. </returns>
        public virtual SqlServerKeyResource GetSqlServerKeyResource(ResourceIdentifier id)
        {
            SqlServerKeyResource.ValidateResourceId(id);
            return new SqlServerKeyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSecurityAlertPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSecurityAlertPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSecurityAlertPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSecurityAlertPolicyResource"/> object. </returns>
        public virtual SqlServerSecurityAlertPolicyResource GetSqlServerSecurityAlertPolicyResource(ResourceIdentifier id)
        {
            SqlServerSecurityAlertPolicyResource.ValidateResourceId(id);
            return new SqlServerSecurityAlertPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerTrustGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerTrustGroupResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerTrustGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerTrustGroupResource"/> object. </returns>
        public virtual SqlServerTrustGroupResource GetSqlServerTrustGroupResource(ResourceIdentifier id)
        {
            SqlServerTrustGroupResource.ValidateResourceId(id);
            return new SqlServerTrustGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SqlServerVulnerabilityAssessmentResource GetSqlServerVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SqlServerVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SqlServerVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlAgentConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlAgentConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="SqlAgentConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlAgentConfigurationResource"/> object. </returns>
        public virtual SqlAgentConfigurationResource GetSqlAgentConfigurationResource(ResourceIdentifier id)
        {
            SqlAgentConfigurationResource.ValidateResourceId(id);
            return new SqlAgentConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionUsageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionUsageResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionUsageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionUsageResource"/> object. </returns>
        public virtual SubscriptionUsageResource GetSubscriptionUsageResource(ResourceIdentifier id)
        {
            SubscriptionUsageResource.ValidateResourceId(id);
            return new SubscriptionUsageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SyncAgentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SyncAgentResource.CreateResourceIdentifier" /> to create a <see cref="SyncAgentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SyncAgentResource"/> object. </returns>
        public virtual SyncAgentResource GetSyncAgentResource(ResourceIdentifier id)
        {
            SyncAgentResource.ValidateResourceId(id);
            return new SyncAgentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SyncGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SyncGroupResource.CreateResourceIdentifier" /> to create a <see cref="SyncGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SyncGroupResource"/> object. </returns>
        public virtual SyncGroupResource GetSyncGroupResource(ResourceIdentifier id)
        {
            SyncGroupResource.ValidateResourceId(id);
            return new SyncGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SyncMemberResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SyncMemberResource.CreateResourceIdentifier" /> to create a <see cref="SyncMemberResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SyncMemberResource"/> object. </returns>
        public virtual SyncMemberResource GetSyncMemberResource(ResourceIdentifier id)
        {
            SyncMemberResource.ValidateResourceId(id);
            return new SyncMemberResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlTimeZoneResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlTimeZoneResource.CreateResourceIdentifier" /> to create a <see cref="SqlTimeZoneResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlTimeZoneResource"/> object. </returns>
        public virtual SqlTimeZoneResource GetSqlTimeZoneResource(ResourceIdentifier id)
        {
            SqlTimeZoneResource.ValidateResourceId(id);
            return new SqlTimeZoneResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerVirtualNetworkRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerVirtualNetworkRuleResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerVirtualNetworkRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerVirtualNetworkRuleResource"/> object. </returns>
        public virtual SqlServerVirtualNetworkRuleResource GetSqlServerVirtualNetworkRuleResource(ResourceIdentifier id)
        {
            SqlServerVirtualNetworkRuleResource.ValidateResourceId(id);
            return new SqlServerVirtualNetworkRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkloadClassifierResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkloadClassifierResource.CreateResourceIdentifier" /> to create a <see cref="WorkloadClassifierResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkloadClassifierResource"/> object. </returns>
        public virtual WorkloadClassifierResource GetWorkloadClassifierResource(ResourceIdentifier id)
        {
            WorkloadClassifierResource.ValidateResourceId(id);
            return new WorkloadClassifierResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkloadGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkloadGroupResource.CreateResourceIdentifier" /> to create a <see cref="WorkloadGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkloadGroupResource"/> object. </returns>
        public virtual WorkloadGroupResource GetWorkloadGroupResource(ResourceIdentifier id)
        {
            WorkloadGroupResource.ValidateResourceId(id);
            return new WorkloadGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BackupShortTermRetentionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BackupShortTermRetentionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="BackupShortTermRetentionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BackupShortTermRetentionPolicyResource"/> object. </returns>
        public virtual BackupShortTermRetentionPolicyResource GetBackupShortTermRetentionPolicyResource(ResourceIdentifier id)
        {
            BackupShortTermRetentionPolicyResource.ValidateResourceId(id);
            return new BackupShortTermRetentionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LedgerDigestUploadResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LedgerDigestUploadResource.CreateResourceIdentifier" /> to create a <see cref="LedgerDigestUploadResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LedgerDigestUploadResource"/> object. </returns>
        public virtual LedgerDigestUploadResource GetLedgerDigestUploadResource(ResourceIdentifier id)
        {
            LedgerDigestUploadResource.ValidateResourceId(id);
            return new LedgerDigestUploadResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="OutboundFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="OutboundFirewallRuleResource.CreateResourceIdentifier" /> to create an <see cref="OutboundFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="OutboundFirewallRuleResource"/> object. </returns>
        public virtual OutboundFirewallRuleResource GetOutboundFirewallRuleResource(ResourceIdentifier id)
        {
            OutboundFirewallRuleResource.ValidateResourceId(id);
            return new OutboundFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionLongTermRetentionManagedInstanceBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionLongTermRetentionManagedInstanceBackupResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionLongTermRetentionManagedInstanceBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionLongTermRetentionManagedInstanceBackupResource"/> object. </returns>
        public virtual SubscriptionLongTermRetentionManagedInstanceBackupResource GetSubscriptionLongTermRetentionManagedInstanceBackupResource(ResourceIdentifier id)
        {
            SubscriptionLongTermRetentionManagedInstanceBackupResource.ValidateResourceId(id);
            return new SubscriptionLongTermRetentionManagedInstanceBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ResourceGroupLongTermRetentionManagedInstanceBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ResourceGroupLongTermRetentionManagedInstanceBackupResource.CreateResourceIdentifier" /> to create a <see cref="ResourceGroupLongTermRetentionManagedInstanceBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ResourceGroupLongTermRetentionManagedInstanceBackupResource"/> object. </returns>
        public virtual ResourceGroupLongTermRetentionManagedInstanceBackupResource GetResourceGroupLongTermRetentionManagedInstanceBackupResource(ResourceIdentifier id)
        {
            ResourceGroupLongTermRetentionManagedInstanceBackupResource.ValidateResourceId(id);
            return new ResourceGroupLongTermRetentionManagedInstanceBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RestorableDroppedManagedDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RestorableDroppedManagedDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="RestorableDroppedManagedDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RestorableDroppedManagedDatabaseResource"/> object. </returns>
        public virtual RestorableDroppedManagedDatabaseResource GetRestorableDroppedManagedDatabaseResource(ResourceIdentifier id)
        {
            RestorableDroppedManagedDatabaseResource.ValidateResourceId(id);
            return new RestorableDroppedManagedDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerConnectionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerConnectionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerConnectionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerConnectionPolicyResource"/> object. </returns>
        public virtual SqlServerConnectionPolicyResource GetSqlServerConnectionPolicyResource(ResourceIdentifier id)
        {
            SqlServerConnectionPolicyResource.ValidateResourceId(id);
            return new SqlServerConnectionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DistributedAvailabilityGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DistributedAvailabilityGroupResource.CreateResourceIdentifier" /> to create a <see cref="DistributedAvailabilityGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DistributedAvailabilityGroupResource"/> object. </returns>
        public virtual DistributedAvailabilityGroupResource GetDistributedAvailabilityGroupResource(ResourceIdentifier id)
        {
            DistributedAvailabilityGroupResource.ValidateResourceId(id);
            return new DistributedAvailabilityGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceServerTrustCertificateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceServerTrustCertificateResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceServerTrustCertificateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceServerTrustCertificateResource"/> object. </returns>
        public virtual ManagedInstanceServerTrustCertificateResource GetManagedInstanceServerTrustCertificateResource(ResourceIdentifier id)
        {
            ManagedInstanceServerTrustCertificateResource.ValidateResourceId(id);
            return new ManagedInstanceServerTrustCertificateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="EndpointCertificateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="EndpointCertificateResource.CreateResourceIdentifier" /> to create an <see cref="EndpointCertificateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="EndpointCertificateResource"/> object. </returns>
        public virtual EndpointCertificateResource GetEndpointCertificateResource(ResourceIdentifier id)
        {
            EndpointCertificateResource.ValidateResourceId(id);
            return new EndpointCertificateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseSensitivityLabelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseSensitivityLabelResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseSensitivityLabelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseSensitivityLabelResource"/> object. </returns>
        public virtual ManagedDatabaseSensitivityLabelResource GetManagedDatabaseSensitivityLabelResource(ResourceIdentifier id)
        {
            ManagedDatabaseSensitivityLabelResource.ValidateResourceId(id);
            return new ManagedDatabaseSensitivityLabelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSensitivityLabelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSensitivityLabelResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSensitivityLabelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSensitivityLabelResource"/> object. </returns>
        public virtual SqlDatabaseSensitivityLabelResource GetSqlDatabaseSensitivityLabelResource(ResourceIdentifier id)
        {
            SqlDatabaseSensitivityLabelResource.ValidateResourceId(id);
            return new SqlDatabaseSensitivityLabelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerBlobAuditingPolicyResource"/> object. </returns>
        public virtual SqlServerBlobAuditingPolicyResource GetSqlServerBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SqlServerBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SqlServerBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseBlobAuditingPolicyResource"/> object. </returns>
        public virtual SqlDatabaseBlobAuditingPolicyResource GetSqlDatabaseBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            SqlDatabaseBlobAuditingPolicyResource.ValidateResourceId(id);
            return new SqlDatabaseBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExtendedDatabaseBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExtendedDatabaseBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ExtendedDatabaseBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExtendedDatabaseBlobAuditingPolicyResource"/> object. </returns>
        public virtual ExtendedDatabaseBlobAuditingPolicyResource GetExtendedDatabaseBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            ExtendedDatabaseBlobAuditingPolicyResource.ValidateResourceId(id);
            return new ExtendedDatabaseBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExtendedServerBlobAuditingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExtendedServerBlobAuditingPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ExtendedServerBlobAuditingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ExtendedServerBlobAuditingPolicyResource"/> object. </returns>
        public virtual ExtendedServerBlobAuditingPolicyResource GetExtendedServerBlobAuditingPolicyResource(ResourceIdentifier id)
        {
            ExtendedServerBlobAuditingPolicyResource.ValidateResourceId(id);
            return new ExtendedServerBlobAuditingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatabaseAdvancedThreatProtectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatabaseAdvancedThreatProtectionResource.CreateResourceIdentifier" /> to create a <see cref="DatabaseAdvancedThreatProtectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatabaseAdvancedThreatProtectionResource"/> object. </returns>
        public virtual DatabaseAdvancedThreatProtectionResource GetDatabaseAdvancedThreatProtectionResource(ResourceIdentifier id)
        {
            DatabaseAdvancedThreatProtectionResource.ValidateResourceId(id);
            return new DatabaseAdvancedThreatProtectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServerAdvancedThreatProtectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServerAdvancedThreatProtectionResource.CreateResourceIdentifier" /> to create a <see cref="ServerAdvancedThreatProtectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServerAdvancedThreatProtectionResource"/> object. </returns>
        public virtual ServerAdvancedThreatProtectionResource GetServerAdvancedThreatProtectionResource(ResourceIdentifier id)
        {
            ServerAdvancedThreatProtectionResource.ValidateResourceId(id);
            return new ServerAdvancedThreatProtectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedServerDnsAliasResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedServerDnsAliasResource.CreateResourceIdentifier" /> to create a <see cref="ManagedServerDnsAliasResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedServerDnsAliasResource"/> object. </returns>
        public virtual ManagedServerDnsAliasResource GetManagedServerDnsAliasResource(ResourceIdentifier id)
        {
            ManagedServerDnsAliasResource.ValidateResourceId(id);
            return new ManagedServerDnsAliasResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseAdvancedThreatProtectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseAdvancedThreatProtectionResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseAdvancedThreatProtectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseAdvancedThreatProtectionResource"/> object. </returns>
        public virtual ManagedDatabaseAdvancedThreatProtectionResource GetManagedDatabaseAdvancedThreatProtectionResource(ResourceIdentifier id)
        {
            ManagedDatabaseAdvancedThreatProtectionResource.ValidateResourceId(id);
            return new ManagedDatabaseAdvancedThreatProtectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceAdvancedThreatProtectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceAdvancedThreatProtectionResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceAdvancedThreatProtectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceAdvancedThreatProtectionResource"/> object. </returns>
        public virtual ManagedInstanceAdvancedThreatProtectionResource GetManagedInstanceAdvancedThreatProtectionResource(ResourceIdentifier id)
        {
            ManagedInstanceAdvancedThreatProtectionResource.ValidateResourceId(id);
            return new ManagedInstanceAdvancedThreatProtectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceDtcResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceDtcResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceDtcResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceDtcResource"/> object. </returns>
        public virtual ManagedInstanceDtcResource GetManagedInstanceDtcResource(ResourceIdentifier id)
        {
            ManagedInstanceDtcResource.ValidateResourceId(id);
            return new ManagedInstanceDtcResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualClusterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualClusterResource.CreateResourceIdentifier" /> to create a <see cref="VirtualClusterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualClusterResource"/> object. </returns>
        public virtual VirtualClusterResource GetVirtualClusterResource(ResourceIdentifier id)
        {
            VirtualClusterResource.ValidateResourceId(id);
            return new VirtualClusterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="InstanceFailoverGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InstanceFailoverGroupResource.CreateResourceIdentifier" /> to create an <see cref="InstanceFailoverGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="InstanceFailoverGroupResource"/> object. </returns>
        public virtual InstanceFailoverGroupResource GetInstanceFailoverGroupResource(ResourceIdentifier id)
        {
            InstanceFailoverGroupResource.ValidateResourceId(id);
            return new InstanceFailoverGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseRestoreDetailResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseRestoreDetailResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseRestoreDetailResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseRestoreDetailResource"/> object. </returns>
        public virtual ManagedDatabaseRestoreDetailResource GetManagedDatabaseRestoreDetailResource(ResourceIdentifier id)
        {
            ManagedDatabaseRestoreDetailResource.ValidateResourceId(id);
            return new ManagedDatabaseRestoreDetailResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseResource"/> object. </returns>
        public virtual SqlDatabaseResource GetSqlDatabaseResource(ResourceIdentifier id)
        {
            SqlDatabaseResource.ValidateResourceId(id);
            return new SqlDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ElasticPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ElasticPoolResource.CreateResourceIdentifier" /> to create an <see cref="ElasticPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ElasticPoolResource"/> object. </returns>
        public virtual ElasticPoolResource GetElasticPoolResource(ResourceIdentifier id)
        {
            ElasticPoolResource.ValidateResourceId(id);
            return new ElasticPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="ManagedDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedDatabaseResource"/> object. </returns>
        public virtual ManagedDatabaseResource GetManagedDatabaseResource(ResourceIdentifier id)
        {
            ManagedDatabaseResource.ValidateResourceId(id);
            return new ManagedDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceResource"/> object. </returns>
        public virtual ManagedInstanceResource GetManagedInstanceResource(ResourceIdentifier id)
        {
            ManagedInstanceResource.ValidateResourceId(id);
            return new ManagedInstanceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedLedgerDigestUploadResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedLedgerDigestUploadResource.CreateResourceIdentifier" /> to create a <see cref="ManagedLedgerDigestUploadResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedLedgerDigestUploadResource"/> object. </returns>
        public virtual ManagedLedgerDigestUploadResource GetManagedLedgerDigestUploadResource(ResourceIdentifier id)
        {
            ManagedLedgerDigestUploadResource.ValidateResourceId(id);
            return new ManagedLedgerDigestUploadResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RecoverableDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RecoverableDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="RecoverableDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RecoverableDatabaseResource"/> object. </returns>
        public virtual RecoverableDatabaseResource GetRecoverableDatabaseResource(ResourceIdentifier id)
        {
            RecoverableDatabaseResource.ValidateResourceId(id);
            return new RecoverableDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RestorableDroppedDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RestorableDroppedDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="RestorableDroppedDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RestorableDroppedDatabaseResource"/> object. </returns>
        public virtual RestorableDroppedDatabaseResource GetRestorableDroppedDatabaseResource(ResourceIdentifier id)
        {
            RestorableDroppedDatabaseResource.ValidateResourceId(id);
            return new RestorableDroppedDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceServerConfigurationOptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceServerConfigurationOptionResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceServerConfigurationOptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceServerConfigurationOptionResource"/> object. </returns>
        public virtual ManagedInstanceServerConfigurationOptionResource GetManagedInstanceServerConfigurationOptionResource(ResourceIdentifier id)
        {
            ManagedInstanceServerConfigurationOptionResource.ValidateResourceId(id);
            return new ManagedInstanceServerConfigurationOptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedInstanceStartStopScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedInstanceStartStopScheduleResource.CreateResourceIdentifier" /> to create a <see cref="ManagedInstanceStartStopScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedInstanceStartStopScheduleResource"/> object. </returns>
        public virtual ManagedInstanceStartStopScheduleResource GetManagedInstanceStartStopScheduleResource(ResourceIdentifier id)
        {
            ManagedInstanceStartStopScheduleResource.ValidateResourceId(id);
            return new ManagedInstanceStartStopScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicalDatabaseTransparentDataEncryptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicalDatabaseTransparentDataEncryptionResource.CreateResourceIdentifier" /> to create a <see cref="LogicalDatabaseTransparentDataEncryptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicalDatabaseTransparentDataEncryptionResource"/> object. </returns>
        public virtual LogicalDatabaseTransparentDataEncryptionResource GetLogicalDatabaseTransparentDataEncryptionResource(ResourceIdentifier id)
        {
            LogicalDatabaseTransparentDataEncryptionResource.ValidateResourceId(id);
            return new LogicalDatabaseTransparentDataEncryptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IPv6FirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IPv6FirewallRuleResource.CreateResourceIdentifier" /> to create an <see cref="IPv6FirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IPv6FirewallRuleResource"/> object. </returns>
        public virtual IPv6FirewallRuleResource GetIPv6FirewallRuleResource(ResourceIdentifier id)
        {
            IPv6FirewallRuleResource.ValidateResourceId(id);
            return new IPv6FirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> object. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentBaselineResource GetSqlServerSqlVulnerabilityAssessmentBaselineResource(ResourceIdentifier id)
        {
            SqlServerSqlVulnerabilityAssessmentBaselineResource.ValidateResourceId(id);
            return new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> object. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentBaselineResource GetSqlDatabaseSqlVulnerabilityAssessmentBaselineResource(ResourceIdentifier id)
        {
            SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.ValidateResourceId(id);
            return new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineRuleResource"/> object. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentBaselineRuleResource GetSqlServerSqlVulnerabilityAssessmentBaselineRuleResource(ResourceIdentifier id)
        {
            SqlServerSqlVulnerabilityAssessmentBaselineRuleResource.ValidateResourceId(id);
            return new SqlServerSqlVulnerabilityAssessmentBaselineRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource"/> object. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource(ResourceIdentifier id)
        {
            SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource.ValidateResourceId(id);
            return new SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> object. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentScanResultResource GetSqlServerSqlVulnerabilityAssessmentScanResultResource(ResourceIdentifier id)
        {
            SqlServerSqlVulnerabilityAssessmentScanResultResource.ValidateResourceId(id);
            return new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResultResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResultResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResultResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResultResource"/> object. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentScanResultResource GetSqlDatabaseSqlVulnerabilityAssessmentScanResultResource(ResourceIdentifier id)
        {
            SqlDatabaseSqlVulnerabilityAssessmentScanResultResource.ValidateResourceId(id);
            return new SqlDatabaseSqlVulnerabilityAssessmentScanResultResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> object. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentScanResource GetSqlServerSqlVulnerabilityAssessmentScanResource(ResourceIdentifier id)
        {
            SqlServerSqlVulnerabilityAssessmentScanResource.ValidateResourceId(id);
            return new SqlServerSqlVulnerabilityAssessmentScanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> object. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentScanResource GetSqlDatabaseSqlVulnerabilityAssessmentScanResource(ResourceIdentifier id)
        {
            SqlDatabaseSqlVulnerabilityAssessmentScanResource.ValidateResourceId(id);
            return new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerSqlVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentResource GetSqlServerSqlVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SqlServerSqlVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SqlServerSqlVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource.CreateResourceIdentifier" /> to create a <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> object. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentResource GetSqlDatabaseSqlVulnerabilityAssessmentResource(ResourceIdentifier id)
        {
            SqlDatabaseSqlVulnerabilityAssessmentResource.ValidateResourceId(id);
            return new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FailoverGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FailoverGroupResource.CreateResourceIdentifier" /> to create a <see cref="FailoverGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FailoverGroupResource"/> object. </returns>
        public virtual FailoverGroupResource GetFailoverGroupResource(ResourceIdentifier id)
        {
            FailoverGroupResource.ValidateResourceId(id);
            return new FailoverGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="InstancePoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="InstancePoolResource.CreateResourceIdentifier" /> to create an <see cref="InstancePoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="InstancePoolResource"/> object. </returns>
        public virtual InstancePoolResource GetInstancePoolResource(ResourceIdentifier id)
        {
            InstancePoolResource.ValidateResourceId(id);
            return new InstancePoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SubscriptionLongTermRetentionBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SubscriptionLongTermRetentionBackupResource.CreateResourceIdentifier" /> to create a <see cref="SubscriptionLongTermRetentionBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SubscriptionLongTermRetentionBackupResource"/> object. </returns>
        public virtual SubscriptionLongTermRetentionBackupResource GetSubscriptionLongTermRetentionBackupResource(ResourceIdentifier id)
        {
            SubscriptionLongTermRetentionBackupResource.ValidateResourceId(id);
            return new SubscriptionLongTermRetentionBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ResourceGroupLongTermRetentionBackupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ResourceGroupLongTermRetentionBackupResource.CreateResourceIdentifier" /> to create a <see cref="ResourceGroupLongTermRetentionBackupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ResourceGroupLongTermRetentionBackupResource"/> object. </returns>
        public virtual ResourceGroupLongTermRetentionBackupResource GetResourceGroupLongTermRetentionBackupResource(ResourceIdentifier id)
        {
            ResourceGroupLongTermRetentionBackupResource.ValidateResourceId(id);
            return new ResourceGroupLongTermRetentionBackupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LongTermRetentionPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LongTermRetentionPolicyResource.CreateResourceIdentifier" /> to create a <see cref="LongTermRetentionPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LongTermRetentionPolicyResource"/> object. </returns>
        public virtual LongTermRetentionPolicyResource GetLongTermRetentionPolicyResource(ResourceIdentifier id)
        {
            LongTermRetentionPolicyResource.ValidateResourceId(id);
            return new LongTermRetentionPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerResource"/> object. </returns>
        public virtual SqlServerResource GetSqlServerResource(ResourceIdentifier id)
        {
            SqlServerResource.ValidateResourceId(id);
            return new SqlServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlServerDatabaseReplicationLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlServerDatabaseReplicationLinkResource.CreateResourceIdentifier" /> to create a <see cref="SqlServerDatabaseReplicationLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlServerDatabaseReplicationLinkResource"/> object. </returns>
        public virtual SqlServerDatabaseReplicationLinkResource GetSqlServerDatabaseReplicationLinkResource(ResourceIdentifier id)
        {
            SqlServerDatabaseReplicationLinkResource.ValidateResourceId(id);
            return new SqlServerDatabaseReplicationLinkResource(Client, id);
        }
    }
}
