// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the EncryptionProtector data model.
    /// The server encryption protector.
    /// </summary>
    public partial class EncryptionProtectorData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EncryptionProtectorData"/>. </summary>
        public EncryptionProtectorData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EncryptionProtectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of encryption protector. This is metadata used for the Azure portal experience. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="subregion"> Subregion of the encryption protector. </param>
        /// <param name="serverKeyName"> The name of the server key. </param>
        /// <param name="serverKeyType"> The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. </param>
        /// <param name="uri"> The URI of the server key. </param>
        /// <param name="thumbprint"> Thumbprint of the server key. </param>
        /// <param name="isAutoRotationEnabled"> Key auto rotation opt-in flag. Either true or false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EncryptionProtectorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string kind, AzureLocation? location, string subregion, string serverKeyName, SqlServerKeyType? serverKeyType, Uri uri, string thumbprint, bool? isAutoRotationEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Kind = kind;
            Location = location;
            Subregion = subregion;
            ServerKeyName = serverKeyName;
            ServerKeyType = serverKeyType;
            Uri = uri;
            Thumbprint = thumbprint;
            IsAutoRotationEnabled = isAutoRotationEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Kind of encryption protector. This is metadata used for the Azure portal experience. </summary>
        [WirePath("kind")]
        public string Kind { get; }
        /// <summary> Resource location. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
        /// <summary> Subregion of the encryption protector. </summary>
        [WirePath("properties.subregion")]
        public string Subregion { get; }
        /// <summary> The name of the server key. </summary>
        [WirePath("properties.serverKeyName")]
        public string ServerKeyName { get; set; }
        /// <summary> The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. </summary>
        [WirePath("properties.serverKeyType")]
        public SqlServerKeyType? ServerKeyType { get; set; }
        /// <summary> The URI of the server key. </summary>
        [WirePath("properties.uri")]
        public Uri Uri { get; }
        /// <summary> Thumbprint of the server key. </summary>
        [WirePath("properties.thumbprint")]
        public string Thumbprint { get; }
        /// <summary> Key auto rotation opt-in flag. Either true or false. </summary>
        [WirePath("properties.autoRotationEnabled")]
        public bool? IsAutoRotationEnabled { get; set; }
    }
}
