// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the ElasticPool data model.
    /// An elastic pool.
    /// </summary>
    public partial class ElasticPoolData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticPoolData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ElasticPoolData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="ElasticPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku">
        /// The elastic pool SKU.
        ///
        /// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
        ///
        /// ```azurecli
        /// az sql elastic-pool list-editions -l &lt;location&gt; -o table
        /// ````
        ///
        /// </param>
        /// <param name="kind"> Kind of elastic pool. This is metadata used for the Azure portal experience. </param>
        /// <param name="state"> The state of the elastic pool. </param>
        /// <param name="createdOn"> The creation date of the elastic pool (ISO8601 format). </param>
        /// <param name="maxSizeBytes"> The storage limit for the database elastic pool in bytes. </param>
        /// <param name="minCapacity"> Minimal capacity that serverless pool will not shrink below, if not paused. </param>
        /// <param name="perDatabaseSettings"> The per database settings for the elastic pool. </param>
        /// <param name="isZoneRedundant"> Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones. </param>
        /// <param name="licenseType"> The license type to apply for this elastic pool. </param>
        /// <param name="maintenanceConfigurationId"> Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur. </param>
        /// <param name="highAvailabilityReplicaCount"> The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools. </param>
        /// <param name="preferredEnclaveType"> Type of enclave requested on the elastic pool. </param>
        /// <param name="availabilityZone"> Specifies the availability zone the pool's primary replica is pinned to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticPoolData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, SqlSku sku, string kind, ElasticPoolState? state, DateTimeOffset? createdOn, long? maxSizeBytes, double? minCapacity, ElasticPoolPerDatabaseSettings perDatabaseSettings, bool? isZoneRedundant, ElasticPoolLicenseType? licenseType, ResourceIdentifier maintenanceConfigurationId, int? highAvailabilityReplicaCount, SqlAlwaysEncryptedEnclaveType? preferredEnclaveType, SqlAvailabilityZoneType? availabilityZone, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            Kind = kind;
            State = state;
            CreatedOn = createdOn;
            MaxSizeBytes = maxSizeBytes;
            MinCapacity = minCapacity;
            PerDatabaseSettings = perDatabaseSettings;
            IsZoneRedundant = isZoneRedundant;
            LicenseType = licenseType;
            MaintenanceConfigurationId = maintenanceConfigurationId;
            HighAvailabilityReplicaCount = highAvailabilityReplicaCount;
            PreferredEnclaveType = preferredEnclaveType;
            AvailabilityZone = availabilityZone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ElasticPoolData"/> for deserialization. </summary>
        internal ElasticPoolData()
        {
        }

        /// <summary>
        /// The elastic pool SKU.
        ///
        /// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
        ///
        /// ```azurecli
        /// az sql elastic-pool list-editions -l &lt;location&gt; -o table
        /// ````
        ///
        /// </summary>
        [WirePath("sku")]
        public SqlSku Sku { get; set; }
        /// <summary> Kind of elastic pool. This is metadata used for the Azure portal experience. </summary>
        [WirePath("kind")]
        public string Kind { get; }
        /// <summary> The state of the elastic pool. </summary>
        [WirePath("properties.state")]
        public ElasticPoolState? State { get; }
        /// <summary> The creation date of the elastic pool (ISO8601 format). </summary>
        [WirePath("properties.creationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The storage limit for the database elastic pool in bytes. </summary>
        [WirePath("properties.maxSizeBytes")]
        public long? MaxSizeBytes { get; set; }
        /// <summary> Minimal capacity that serverless pool will not shrink below, if not paused. </summary>
        [WirePath("properties.minCapacity")]
        public double? MinCapacity { get; set; }
        /// <summary> The per database settings for the elastic pool. </summary>
        [WirePath("properties.perDatabaseSettings")]
        public ElasticPoolPerDatabaseSettings PerDatabaseSettings { get; set; }
        /// <summary> Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones. </summary>
        [WirePath("properties.zoneRedundant")]
        public bool? IsZoneRedundant { get; set; }
        /// <summary> The license type to apply for this elastic pool. </summary>
        [WirePath("properties.licenseType")]
        public ElasticPoolLicenseType? LicenseType { get; set; }
        /// <summary> Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur. </summary>
        [WirePath("properties.maintenanceConfigurationId")]
        public ResourceIdentifier MaintenanceConfigurationId { get; set; }
        /// <summary> The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools. </summary>
        [WirePath("properties.highAvailabilityReplicaCount")]
        public int? HighAvailabilityReplicaCount { get; set; }
        /// <summary> Type of enclave requested on the elastic pool. </summary>
        [WirePath("properties.preferredEnclaveType")]
        public SqlAlwaysEncryptedEnclaveType? PreferredEnclaveType { get; set; }
        /// <summary> Specifies the availability zone the pool's primary replica is pinned to. </summary>
        [WirePath("properties.availabilityZone")]
        public SqlAvailabilityZoneType? AvailabilityZone { get; set; }
    }
}
