// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_WorkloadClassifierCollection
    {
        // Gets a workload classifier for a data warehouse
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAWorkloadClassifierForADataWarehouse()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetWorkloadClassifier.json
            // this example is just showing the usage of "WorkloadClassifiers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation
            string workloadClassifierName = "wlm_classifier";
            WorkloadClassifierResource result = await collection.GetAsync(workloadClassifierName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadClassifierData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a workload classifier for a data warehouse
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsAWorkloadClassifierForADataWarehouse()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetWorkloadClassifier.json
            // this example is just showing the usage of "WorkloadClassifiers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation
            string workloadClassifierName = "wlm_classifier";
            bool result = await collection.ExistsAsync(workloadClassifierName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a workload classifier for a data warehouse
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsAWorkloadClassifierForADataWarehouse()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetWorkloadClassifier.json
            // this example is just showing the usage of "WorkloadClassifiers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation
            string workloadClassifierName = "wlm_classifier";
            NullableResponse<WorkloadClassifierResource> response = await collection.GetIfExistsAsync(workloadClassifierName);
            WorkloadClassifierResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                WorkloadClassifierData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a workload group with all properties specified.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAWorkloadGroupWithAllPropertiesSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateWorkloadClassifierMax.json
            // this example is just showing the usage of "WorkloadClassifiers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation
            string workloadClassifierName = "wlm_workloadclassifier";
            WorkloadClassifierData data = new WorkloadClassifierData()
            {
                MemberName = "dbo",
                Label = "test_label",
                Context = "test_context",
                StartTime = "12:00",
                EndTime = "14:00",
                Importance = "high",
            };
            ArmOperation<WorkloadClassifierResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, workloadClassifierName, data);
            WorkloadClassifierResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadClassifierData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a workload group with the required properties specified.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAWorkloadGroupWithTheRequiredPropertiesSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateWorkloadClassifierMin.json
            // this example is just showing the usage of "WorkloadClassifiers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation
            string workloadClassifierName = "wlm_workloadclassifier";
            WorkloadClassifierData data = new WorkloadClassifierData()
            {
                MemberName = "dbo",
            };
            ArmOperation<WorkloadClassifierResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, workloadClassifierName, data);
            WorkloadClassifierResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            WorkloadClassifierData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get the list of workload classifiers for a workload group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetTheListOfWorkloadClassifiersForAWorkloadGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetWorkloadClassifierList.json
            // this example is just showing the usage of "WorkloadClassifiers_ListByWorkloadGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this WorkloadGroupResource created on azure
            // for more information of creating WorkloadGroupResource, please refer to the document of WorkloadGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default-SQL-SouthEastAsia";
            string serverName = "testsvr";
            string databaseName = "testdb";
            string workloadGroupName = "wlm_workloadgroup";
            ResourceIdentifier workloadGroupResourceId = WorkloadGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, workloadGroupName);
            WorkloadGroupResource workloadGroup = client.GetWorkloadGroupResource(workloadGroupResourceId);

            // get the collection of this WorkloadClassifierResource
            WorkloadClassifierCollection collection = workloadGroup.GetWorkloadClassifiers();

            // invoke the operation and iterate over the result
            await foreach (WorkloadClassifierResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                WorkloadClassifierData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
