// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SubscriptionUsageResource
    {
        // Get specific subscription usage in the given location.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSpecificSubscriptionUsageInTheGivenLocation()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SubscriptionUsageGet.json
            // this example is just showing the usage of "SubscriptionUsages_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionUsageResource created on azure
            // for more information of creating SubscriptionUsageResource, please refer to the document of SubscriptionUsageResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            AzureLocation locationName = new AzureLocation("WestUS");
            string usageName = "ServerQuota";
            ResourceIdentifier subscriptionUsageResourceId = SubscriptionUsageResource.CreateResourceIdentifier(subscriptionId, locationName, usageName);
            SubscriptionUsageResource subscriptionUsage = client.GetSubscriptionUsageResource(subscriptionUsageResourceId);

            // invoke the operation
            SubscriptionUsageResource result = await subscriptionUsage.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SubscriptionUsageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
