// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlTimeZoneResource
    {
        // Get managed instance time zone
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetManagedInstanceTimeZone()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedInstanceTimeZoneGet.json
            // this example is just showing the usage of "TimeZones_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlTimeZoneResource created on azure
            // for more information of creating SqlTimeZoneResource, please refer to the document of SqlTimeZoneResource
            string subscriptionId = "37d5e605-6142-4d79-b564-28b6dbfeec0f";
            AzureLocation locationName = new AzureLocation("canadaeast");
            string timeZoneId = "Haiti Standard Time";
            ResourceIdentifier sqlTimeZoneResourceId = SqlTimeZoneResource.CreateResourceIdentifier(subscriptionId, locationName, timeZoneId);
            SqlTimeZoneResource sqlTimeZone = client.GetSqlTimeZoneResource(sqlTimeZoneResourceId);

            // invoke the operation
            SqlTimeZoneResource result = await sqlTimeZone.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlTimeZoneData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
