// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerVulnerabilityAssessmentResource
    {
        // Get a server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentGet.json
            // this example is just showing the usage of "ServerVulnerabilityAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerVulnerabilityAssessmentResource, please refer to the document of SqlServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerVulnerabilityAssessmentResourceId = SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerVulnerabilityAssessmentResource sqlServerVulnerabilityAssessment = client.GetSqlServerVulnerabilityAssessmentResource(sqlServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SqlServerVulnerabilityAssessmentResource result = await sqlServerVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a server's vulnerability assessment with all parameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAServerSVulnerabilityAssessmentWithAllParameters()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateMax.json
            // this example is just showing the usage of "ServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerVulnerabilityAssessmentResource, please refer to the document of SqlServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerVulnerabilityAssessmentResourceId = SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerVulnerabilityAssessmentResource sqlServerVulnerabilityAssessment = client.GetSqlServerVulnerabilityAssessmentResource(sqlServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SqlServerVulnerabilityAssessmentData data = new SqlServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
                RecurringScans = new VulnerabilityAssessmentRecurringScansProperties()
                {
                    IsEnabled = true,
                    EmailSubscriptionAdmins = true,
                    Emails =
{
"email1@mail.com","email2@mail.com"
},
                },
            };
            ArmOperation<SqlServerVulnerabilityAssessmentResource> lro = await sqlServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SqlServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a server's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateStorageAccessKeyMin.json
            // this example is just showing the usage of "ServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerVulnerabilityAssessmentResource, please refer to the document of SqlServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerVulnerabilityAssessmentResourceId = SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerVulnerabilityAssessmentResource sqlServerVulnerabilityAssessment = client.GetSqlServerVulnerabilityAssessmentResource(sqlServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SqlServerVulnerabilityAssessmentData data = new SqlServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SqlServerVulnerabilityAssessmentResource> lro = await sqlServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SqlServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a server's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAServerSVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateContainerSasKeyMin.json
            // this example is just showing the usage of "ServerVulnerabilityAssessments_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerVulnerabilityAssessmentResource, please refer to the document of SqlServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerVulnerabilityAssessmentResourceId = SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerVulnerabilityAssessmentResource sqlServerVulnerabilityAssessment = client.GetSqlServerVulnerabilityAssessmentResource(sqlServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            SqlServerVulnerabilityAssessmentData data = new SqlServerVulnerabilityAssessmentData()
            {
                StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
                StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            };
            ArmOperation<SqlServerVulnerabilityAssessmentResource> lro = await sqlServerVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed, data);
            SqlServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Remove a server's vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RemoveAServerSVulnerabilityAssessment()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentDelete.json
            // this example is just showing the usage of "ServerVulnerabilityAssessments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerVulnerabilityAssessmentResource, please refer to the document of SqlServerVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerVulnerabilityAssessmentResourceId = SqlServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerVulnerabilityAssessmentResource sqlServerVulnerabilityAssessment = client.GetSqlServerVulnerabilityAssessmentResource(sqlServerVulnerabilityAssessmentResourceId);

            // invoke the operation
            await sqlServerVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
