// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerTrustGroupResource
    {
        // Get server trust group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetServerTrustGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerTrustGroupGet.json
            // this example is just showing the usage of "ServerTrustGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerTrustGroupResource created on azure
            // for more information of creating SqlServerTrustGroupResource, please refer to the document of SqlServerTrustGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string serverTrustGroupName = "server-trust-group-test";
            ResourceIdentifier sqlServerTrustGroupResourceId = SqlServerTrustGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, serverTrustGroupName);
            SqlServerTrustGroupResource sqlServerTrustGroup = client.GetSqlServerTrustGroupResource(sqlServerTrustGroupResourceId);

            // invoke the operation
            SqlServerTrustGroupResource result = await sqlServerTrustGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerTrustGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create server trust group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateServerTrustGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerTrustGroupCreate.json
            // this example is just showing the usage of "ServerTrustGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerTrustGroupResource created on azure
            // for more information of creating SqlServerTrustGroupResource, please refer to the document of SqlServerTrustGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string serverTrustGroupName = "server-trust-group-test";
            ResourceIdentifier sqlServerTrustGroupResourceId = SqlServerTrustGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, serverTrustGroupName);
            SqlServerTrustGroupResource sqlServerTrustGroup = client.GetSqlServerTrustGroupResource(sqlServerTrustGroupResourceId);

            // invoke the operation
            SqlServerTrustGroupData data = new SqlServerTrustGroupData()
            {
                GroupMembers =
{
new ServerTrustGroupServerInfo(new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1")),new ServerTrustGroupServerInfo(new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2"))
},
                TrustScopes =
{
ServerTrustGroupPropertiesTrustScopesItem.GlobalTransactions,ServerTrustGroupPropertiesTrustScopesItem.ServiceBroker
},
            };
            ArmOperation<SqlServerTrustGroupResource> lro = await sqlServerTrustGroup.UpdateAsync(WaitUntil.Completed, data);
            SqlServerTrustGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerTrustGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Drop server trust group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DropServerTrustGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerTrustGroupDelete.json
            // this example is just showing the usage of "ServerTrustGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerTrustGroupResource created on azure
            // for more information of creating SqlServerTrustGroupResource, please refer to the document of SqlServerTrustGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            AzureLocation locationName = new AzureLocation("Japan East");
            string serverTrustGroupName = "server-trust-group-test";
            ResourceIdentifier sqlServerTrustGroupResourceId = SqlServerTrustGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, locationName, serverTrustGroupName);
            SqlServerTrustGroupResource sqlServerTrustGroup = client.GetSqlServerTrustGroupResource(sqlServerTrustGroupResourceId);

            // invoke the operation
            await sqlServerTrustGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
