// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerSqlVulnerabilityAssessmentScanResultResource
    {
        // Get a system database SQL Vulnerability Assessment scan result for scan id and scan result id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASystemDatabaseSQLVulnerabilityAssessmentScanResultForScanIdAndScanResultId()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentScansResults.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScanResult_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentScanResultResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentScanResultResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentScanResultResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            string scanId = "scanId1";
            string scanResultId = "VA1234";
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentScanResultResourceId = SqlServerSqlVulnerabilityAssessmentScanResultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, scanResultId);
            SqlServerSqlVulnerabilityAssessmentScanResultResource sqlServerSqlVulnerabilityAssessmentScanResult = client.GetSqlServerSqlVulnerabilityAssessmentScanResultResource(sqlServerSqlVulnerabilityAssessmentScanResultResourceId);

            // invoke the operation
            SqlServerSqlVulnerabilityAssessmentScanResultResource result = await sqlServerSqlVulnerabilityAssessmentScanResult.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanResultData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
