// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerSqlVulnerabilityAssessmentScanCollection
    {
        // Gets the list of a database vulnerability assessment scan records
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetsTheListOfADatabaseVulnerabilityAssessmentScanRecords()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentScanRecordsListByDatabase.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_ListBySqlVulnerabilityAssessments" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentResourceId = SqlServerSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerSqlVulnerabilityAssessmentResource sqlServerSqlVulnerabilityAssessment = client.GetSqlServerSqlVulnerabilityAssessmentResource(sqlServerSqlVulnerabilityAssessmentResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentScanResource
            SqlServerSqlVulnerabilityAssessmentScanCollection collection = sqlServerSqlVulnerabilityAssessment.GetSqlServerSqlVulnerabilityAssessmentScans();

            // invoke the operation and iterate over the result
            await foreach (SqlServerSqlVulnerabilityAssessmentScanResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets the a database vulnerability assessment scan records
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheADatabaseVulnerabilityAssessmentScanRecords()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentScan.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentResourceId = SqlServerSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerSqlVulnerabilityAssessmentResource sqlServerSqlVulnerabilityAssessment = client.GetSqlServerSqlVulnerabilityAssessmentResource(sqlServerSqlVulnerabilityAssessmentResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentScanResource
            SqlServerSqlVulnerabilityAssessmentScanCollection collection = sqlServerSqlVulnerabilityAssessment.GetSqlServerSqlVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            SqlServerSqlVulnerabilityAssessmentScanResource result = await collection.GetAsync(scanId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets the a database vulnerability assessment scan records
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsTheADatabaseVulnerabilityAssessmentScanRecords()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentScan.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentResourceId = SqlServerSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerSqlVulnerabilityAssessmentResource sqlServerSqlVulnerabilityAssessment = client.GetSqlServerSqlVulnerabilityAssessmentResource(sqlServerSqlVulnerabilityAssessmentResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentScanResource
            SqlServerSqlVulnerabilityAssessmentScanCollection collection = sqlServerSqlVulnerabilityAssessment.GetSqlServerSqlVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            bool result = await collection.ExistsAsync(scanId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets the a database vulnerability assessment scan records
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsTheADatabaseVulnerabilityAssessmentScanRecords()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentScan.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityassessmenttest-4711";
            string serverName = "vulnerabilityassessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentResourceId = SqlServerSqlVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName);
            SqlServerSqlVulnerabilityAssessmentResource sqlServerSqlVulnerabilityAssessment = client.GetSqlServerSqlVulnerabilityAssessmentResource(sqlServerSqlVulnerabilityAssessmentResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentScanResource
            SqlServerSqlVulnerabilityAssessmentScanCollection collection = sqlServerSqlVulnerabilityAssessment.GetSqlServerSqlVulnerabilityAssessmentScans();

            // invoke the operation
            string scanId = "scan001";
            NullableResponse<SqlServerSqlVulnerabilityAssessmentScanResource> response = await collection.GetIfExistsAsync(scanId);
            SqlServerSqlVulnerabilityAssessmentScanResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
