// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection
    {
        // Gets a system database's sql vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetsASystemDatabaseSSqlVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentRuleBaselineListByBaseline.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentRuleBaseline_ListByBaseline" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentBaselineRuleResource
            SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection collection = sqlServerSqlVulnerabilityAssessmentBaseline.GetSqlServerSqlVulnerabilityAssessmentBaselineRules();

            // invoke the operation and iterate over the result
            await foreach (SqlServerSqlVulnerabilityAssessmentBaselineRuleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a system database's sql vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsASystemDatabaseSSqlVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentRuleBaseline_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentBaselineRuleResource
            SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection collection = sqlServerSqlVulnerabilityAssessmentBaseline.GetSqlServerSqlVulnerabilityAssessmentBaselineRules();

            // invoke the operation
            string ruleId = "VA1001";
            SqlServerSqlVulnerabilityAssessmentBaselineRuleResource result = await collection.GetAsync(ruleId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a system database's sql vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetsASystemDatabaseSSqlVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentRuleBaseline_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentBaselineRuleResource
            SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection collection = sqlServerSqlVulnerabilityAssessmentBaseline.GetSqlServerSqlVulnerabilityAssessmentBaselineRules();

            // invoke the operation
            string ruleId = "VA1001";
            bool result = await collection.ExistsAsync(ruleId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a system database's sql vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetsASystemDatabaseSSqlVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentRuleBaselineGet.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentRuleBaseline_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentBaselineRuleResource
            SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection collection = sqlServerSqlVulnerabilityAssessmentBaseline.GetSqlServerSqlVulnerabilityAssessmentBaselineRules();

            // invoke the operation
            string ruleId = "VA1001";
            NullableResponse<SqlServerSqlVulnerabilityAssessmentBaselineRuleResource> response = await collection.GetIfExistsAsync(ruleId);
            SqlServerSqlVulnerabilityAssessmentBaselineRuleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Creates or updates a database's vulnerability assessment rule baseline.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesOrUpdatesADatabaseSVulnerabilityAssessmentRuleBaseline()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentRuleBaselineCreate.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentRuleBaseline_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // get the collection of this SqlServerSqlVulnerabilityAssessmentBaselineRuleResource
            SqlServerSqlVulnerabilityAssessmentBaselineRuleCollection collection = sqlServerSqlVulnerabilityAssessmentBaseline.GetSqlServerSqlVulnerabilityAssessmentBaselineRules();

            // invoke the operation
            string ruleId = "VA1001";
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                IsLatestScan = false,
                Results =
{
new string[]
{
"userA","SELECT"
},new string[]
{
"userB","SELECT"
},new string[]
{
"userC","SELECT"
}
},
            };
            ArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleId, content);
            SqlServerSqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
