// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerSqlVulnerabilityAssessmentBaselineResource
    {
        // Gets a list of database's sql vulnerability assessment rule baselines.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAListOfDatabaseSSqlVulnerabilityAssessmentRuleBaselines()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentBaselineGet.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaseline_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlServerSqlVulnerabilityAssessmentBaselineResource result = await sqlServerSqlVulnerabilityAssessmentBaseline.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Add a database's vulnerability assessment rule baseline from the latest scan result.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AddADatabaseSVulnerabilityAssessmentRuleBaselineFromTheLatestScanResult()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentBaselineAddLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4799";
            string serverName = "vulnerabilityaseessmenttest-6440";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent()
            {
                IsLatestScan = true,
                Results =
{
},
            };
            ArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource> lro = await sqlServerSqlVulnerabilityAssessmentBaseline.UpdateAsync(WaitUntil.Completed, content);
            SqlServerSqlVulnerabilityAssessmentBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Add a database's vulnerability assessment rule baseline list.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AddADatabaseSVulnerabilityAssessmentRuleBaselineList()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentBaselineAdd.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselines_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerSqlVulnerabilityAssessmentBaselineResource created on azure
            // for more information of creating SqlServerSqlVulnerabilityAssessmentBaselineResource, please refer to the document of SqlServerSqlVulnerabilityAssessmentBaselineResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "vulnerabilityaseessmenttest-4711";
            string serverName = "vulnerabilityaseessmenttest-6411";
            VulnerabilityAssessmentName vulnerabilityAssessmentName = VulnerabilityAssessmentName.Default;
            SqlVulnerabilityAssessmentBaselineName baselineName = SqlVulnerabilityAssessmentBaselineName.Default;
            ResourceIdentifier sqlServerSqlVulnerabilityAssessmentBaselineResourceId = SqlServerSqlVulnerabilityAssessmentBaselineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName);
            SqlServerSqlVulnerabilityAssessmentBaselineResource sqlServerSqlVulnerabilityAssessmentBaseline = client.GetSqlServerSqlVulnerabilityAssessmentBaselineResource(sqlServerSqlVulnerabilityAssessmentBaselineResourceId);

            // invoke the operation
            SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent()
            {
                IsLatestScan = false,
                Results =
{
["VA2063"] = new IList<string>[]
{
new string[]
{
"AllowAll","0.0.0.0","255.255.255.255"
}
},
["VA2065"] = new IList<string>[]
{
new string[]
{
"AllowAll","0.0.0.0","255.255.255.255"
}
},
},
            };
            ArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource> lro = await sqlServerSqlVulnerabilityAssessmentBaseline.UpdateAsync(WaitUntil.Completed, content);
            SqlServerSqlVulnerabilityAssessmentBaselineResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
