// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerJobTargetGroupResource
    {
        // Get a target group.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetATargetGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetJobTargetGroup.json
            // this example is just showing the usage of "JobTargetGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobTargetGroupResource created on azure
            // for more information of creating SqlServerJobTargetGroupResource, please refer to the document of SqlServerJobTargetGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string targetGroupName = "targetGroup1";
            ResourceIdentifier sqlServerJobTargetGroupResourceId = SqlServerJobTargetGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, targetGroupName);
            SqlServerJobTargetGroupResource sqlServerJobTargetGroup = client.GetSqlServerJobTargetGroupResource(sqlServerJobTargetGroupResourceId);

            // invoke the operation
            SqlServerJobTargetGroupResource result = await sqlServerJobTargetGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobTargetGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a target group with all properties.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateATargetGroupWithAllProperties()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateJobTargetGroupMax.json
            // this example is just showing the usage of "JobTargetGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobTargetGroupResource created on azure
            // for more information of creating SqlServerJobTargetGroupResource, please refer to the document of SqlServerJobTargetGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string targetGroupName = "targetGroup1";
            ResourceIdentifier sqlServerJobTargetGroupResourceId = SqlServerJobTargetGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, targetGroupName);
            SqlServerJobTargetGroupResource sqlServerJobTargetGroup = client.GetSqlServerJobTargetGroupResource(sqlServerJobTargetGroupResourceId);

            // invoke the operation
            SqlServerJobTargetGroupData data = new SqlServerJobTargetGroupData()
            {
                Members =
{
new JobTarget(JobTargetType.SqlDatabase)
{
MembershipType = JobTargetGroupMembershipType.Exclude,
ServerName = "server1",
DatabaseName = "database1",
},new JobTarget(JobTargetType.SqlServer)
{
MembershipType = JobTargetGroupMembershipType.Include,
ServerName = "server1",
RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
},new JobTarget(JobTargetType.SqlElasticPool)
{
MembershipType = JobTargetGroupMembershipType.Include,
ServerName = "server2",
ElasticPoolName = "pool1",
RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
},new JobTarget(JobTargetType.SqlShardMap)
{
MembershipType = JobTargetGroupMembershipType.Include,
ServerName = "server3",
ShardMapName = "shardMap1",
RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
}
},
            };
            ArmOperation<SqlServerJobTargetGroupResource> lro = await sqlServerJobTargetGroup.UpdateAsync(WaitUntil.Completed, data);
            SqlServerJobTargetGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobTargetGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a target group with minimal properties.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateATargetGroupWithMinimalProperties()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateJobTargetGroupMin.json
            // this example is just showing the usage of "JobTargetGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobTargetGroupResource created on azure
            // for more information of creating SqlServerJobTargetGroupResource, please refer to the document of SqlServerJobTargetGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string targetGroupName = "targetGroup1";
            ResourceIdentifier sqlServerJobTargetGroupResourceId = SqlServerJobTargetGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, targetGroupName);
            SqlServerJobTargetGroupResource sqlServerJobTargetGroup = client.GetSqlServerJobTargetGroupResource(sqlServerJobTargetGroupResourceId);

            // invoke the operation
            SqlServerJobTargetGroupData data = new SqlServerJobTargetGroupData()
            {
                Members =
{
},
            };
            ArmOperation<SqlServerJobTargetGroupResource> lro = await sqlServerJobTargetGroup.UpdateAsync(WaitUntil.Completed, data);
            SqlServerJobTargetGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobTargetGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a target group.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteATargetGroup()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DeleteJobTargetGroup.json
            // this example is just showing the usage of "JobTargetGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobTargetGroupResource created on azure
            // for more information of creating SqlServerJobTargetGroupResource, please refer to the document of SqlServerJobTargetGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string targetGroupName = "targetGroup1";
            ResourceIdentifier sqlServerJobTargetGroupResourceId = SqlServerJobTargetGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, targetGroupName);
            SqlServerJobTargetGroupResource sqlServerJobTargetGroup = client.GetSqlServerJobTargetGroupResource(sqlServerJobTargetGroupResourceId);

            // invoke the operation
            await sqlServerJobTargetGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
