// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerJobStepResource
    {
        // Get the latest version of a job step.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheLatestVersionOfAJobStep()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetJobStepByJob.json
            // this example is just showing the usage of "JobSteps_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobStepResource created on azure
            // for more information of creating SqlServerJobStepResource, please refer to the document of SqlServerJobStepResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string jobName = "job1";
            string stepName = "step1";
            ResourceIdentifier sqlServerJobStepResourceId = SqlServerJobStepResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, jobName, stepName);
            SqlServerJobStepResource sqlServerJobStep = client.GetSqlServerJobStepResource(sqlServerJobStepResourceId);

            // invoke the operation
            SqlServerJobStepResource result = await sqlServerJobStep.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobStepData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a job step with all properties specified.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAJobStepWithAllPropertiesSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateJobStepMax.json
            // this example is just showing the usage of "JobSteps_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobStepResource created on azure
            // for more information of creating SqlServerJobStepResource, please refer to the document of SqlServerJobStepResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string jobName = "job1";
            string stepName = "step1";
            ResourceIdentifier sqlServerJobStepResourceId = SqlServerJobStepResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, jobName, stepName);
            SqlServerJobStepResource sqlServerJobStep = client.GetSqlServerJobStepResource(sqlServerJobStepResourceId);

            // invoke the operation
            SqlServerJobStepData data = new SqlServerJobStepData()
            {
                StepId = 1,
                TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1",
                Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1",
                Action = new JobStepAction("select 2")
                {
                    ActionType = JobStepActionType.TSql,
                    Source = JobStepActionSource.Inline,
                },
                Output = new JobStepOutput("server3", "database3", "mytable5678", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0")
                {
                    OutputType = JobStepOutputType.SqlDatabase,
                    SubscriptionId = Guid.Parse("3501b905-a848-4b5d-96e8-b253f62d735a"),
                    ResourceGroupName = "group3",
                    SchemaName = "myschema1234",
                },
                ExecutionOptions = new JobStepExecutionOptions()
                {
                    TimeoutSeconds = 1234,
                    RetryAttempts = 42,
                    InitialRetryIntervalSeconds = 11,
                    MaximumRetryIntervalSeconds = 222,
                    RetryIntervalBackoffMultiplier = 3,
                },
            };
            ArmOperation<SqlServerJobStepResource> lro = await sqlServerJobStep.UpdateAsync(WaitUntil.Completed, data);
            SqlServerJobStepResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobStepData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a job step with minimal properties specified.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAJobStepWithMinimalPropertiesSpecified()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateJobStepMin.json
            // this example is just showing the usage of "JobSteps_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobStepResource created on azure
            // for more information of creating SqlServerJobStepResource, please refer to the document of SqlServerJobStepResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string jobName = "job1";
            string stepName = "step1";
            ResourceIdentifier sqlServerJobStepResourceId = SqlServerJobStepResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, jobName, stepName);
            SqlServerJobStepResource sqlServerJobStep = client.GetSqlServerJobStepResource(sqlServerJobStepResourceId);

            // invoke the operation
            SqlServerJobStepData data = new SqlServerJobStepData()
            {
                TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0",
                Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0",
                Action = new JobStepAction("select 1"),
            };
            ArmOperation<SqlServerJobStepResource> lro = await sqlServerJobStep.UpdateAsync(WaitUntil.Completed, data);
            SqlServerJobStepResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerJobStepData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a job step.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAJobStep()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DeleteJobStep.json
            // this example is just showing the usage of "JobSteps_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerJobStepResource created on azure
            // for more information of creating SqlServerJobStepResource, please refer to the document of SqlServerJobStepResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "group1";
            string serverName = "server1";
            string jobAgentName = "agent1";
            string jobName = "job1";
            string stepName = "step1";
            ResourceIdentifier sqlServerJobStepResourceId = SqlServerJobStepResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, jobAgentName, jobName, stepName);
            SqlServerJobStepResource sqlServerJobStep = client.GetSqlServerJobStepResource(sqlServerJobStepResourceId);

            // invoke the operation
            await sqlServerJobStep.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
