// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerDnsAliasResource
    {
        // Get server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerDnsAliasGet.json
            // this example is just showing the usage of "ServerDnsAliases_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerDnsAliasResource created on azure
            // for more information of creating SqlServerDnsAliasResource, please refer to the document of SqlServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "dns-alias-server";
            string dnsAliasName = "dns-alias-name-1";
            ResourceIdentifier sqlServerDnsAliasResourceId = SqlServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, dnsAliasName);
            SqlServerDnsAliasResource sqlServerDnsAlias = client.GetSqlServerDnsAliasResource(sqlServerDnsAliasResourceId);

            // invoke the operation
            SqlServerDnsAliasResource result = await sqlServerDnsAlias.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerDnsAliasCreateOrUpdate.json
            // this example is just showing the usage of "ServerDnsAliases_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerDnsAliasResource created on azure
            // for more information of creating SqlServerDnsAliasResource, please refer to the document of SqlServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "dns-alias-server";
            string dnsAliasName = "dns-alias-name-1";
            ResourceIdentifier sqlServerDnsAliasResourceId = SqlServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, dnsAliasName);
            SqlServerDnsAliasResource sqlServerDnsAlias = client.GetSqlServerDnsAliasResource(sqlServerDnsAliasResourceId);

            // invoke the operation
            ArmOperation<SqlServerDnsAliasResource> lro = await sqlServerDnsAlias.UpdateAsync(WaitUntil.Completed);
            SqlServerDnsAliasResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerDnsAliasDelete.json
            // this example is just showing the usage of "ServerDnsAliases_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerDnsAliasResource created on azure
            // for more information of creating SqlServerDnsAliasResource, please refer to the document of SqlServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "dns-alias-server";
            string dnsAliasName = "dns-alias-name-1";
            ResourceIdentifier sqlServerDnsAliasResourceId = SqlServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, dnsAliasName);
            SqlServerDnsAliasResource sqlServerDnsAlias = client.GetSqlServerDnsAliasResource(sqlServerDnsAliasResourceId);

            // invoke the operation
            await sqlServerDnsAlias.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Acquire server DNS alias
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Acquire_AcquireServerDNSAlias()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerDnsAliasAcquire.json
            // this example is just showing the usage of "ServerDnsAliases_Acquire" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerDnsAliasResource created on azure
            // for more information of creating SqlServerDnsAliasResource, please refer to the document of SqlServerDnsAliasResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "Default";
            string serverName = "dns-alias-new-server";
            string dnsAliasName = "dns-alias-name-1";
            ResourceIdentifier sqlServerDnsAliasResourceId = SqlServerDnsAliasResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, dnsAliasName);
            SqlServerDnsAliasResource sqlServerDnsAlias = client.GetSqlServerDnsAliasResource(sqlServerDnsAliasResourceId);

            // invoke the operation
            ServerDnsAliasAcquisition serverDnsAliasAcquisition = new ServerDnsAliasAcquisition(new ResourceIdentifier("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/dns-alias-old-server/dnsAliases/dns-alias-name-1"));
            ArmOperation<SqlServerDnsAliasResource> lro = await sqlServerDnsAlias.AcquireAsync(WaitUntil.Completed, serverDnsAliasAcquisition);
            SqlServerDnsAliasResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerDnsAliasData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
