// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerCommunicationLinkResource
    {
        // Delete a server communication link
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAServerCommunicationLink()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/stable/2014-04-01/examples/ServerCommunicationLinkDelete.json
            // this example is just showing the usage of "ServerCommunicationLinks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerCommunicationLinkResource created on azure
            // for more information of creating SqlServerCommunicationLinkResource, please refer to the document of SqlServerCommunicationLinkResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string serverName = "sqlcrudtest-4645";
            string communicationLinkName = "link1";
            ResourceIdentifier sqlServerCommunicationLinkResourceId = SqlServerCommunicationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, communicationLinkName);
            SqlServerCommunicationLinkResource sqlServerCommunicationLink = client.GetSqlServerCommunicationLinkResource(sqlServerCommunicationLinkResourceId);

            // invoke the operation
            await sqlServerCommunicationLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a server communication link
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServerCommunicationLink()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/stable/2014-04-01/examples/ServerCommunicationLinkGet.json
            // this example is just showing the usage of "ServerCommunicationLinks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerCommunicationLinkResource created on azure
            // for more information of creating SqlServerCommunicationLinkResource, please refer to the document of SqlServerCommunicationLinkResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string serverName = "sqlcrudtest-4645";
            string communicationLinkName = "link1";
            ResourceIdentifier sqlServerCommunicationLinkResourceId = SqlServerCommunicationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, communicationLinkName);
            SqlServerCommunicationLinkResource sqlServerCommunicationLink = client.GetSqlServerCommunicationLinkResource(sqlServerCommunicationLinkResourceId);

            // invoke the operation
            SqlServerCommunicationLinkResource result = await sqlServerCommunicationLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerCommunicationLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a server communication link
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAServerCommunicationLink()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/stable/2014-04-01/examples/ServerCommunicationLinkCreateOrUpdate.json
            // this example is just showing the usage of "ServerCommunicationLinks_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerCommunicationLinkResource created on azure
            // for more information of creating SqlServerCommunicationLinkResource, please refer to the document of SqlServerCommunicationLinkResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-7398";
            string serverName = "sqlcrudtest-4645";
            string communicationLinkName = "link1";
            ResourceIdentifier sqlServerCommunicationLinkResourceId = SqlServerCommunicationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, communicationLinkName);
            SqlServerCommunicationLinkResource sqlServerCommunicationLink = client.GetSqlServerCommunicationLinkResource(sqlServerCommunicationLinkResourceId);

            // invoke the operation
            SqlServerCommunicationLinkData data = new SqlServerCommunicationLinkData()
            {
                PartnerServer = "sqldcrudtest-test",
            };
            ArmOperation<SqlServerCommunicationLinkResource> lro = await sqlServerCommunicationLink.UpdateAsync(WaitUntil.Completed, data);
            SqlServerCommunicationLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerCommunicationLinkData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
