// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlServerAzureADAdministratorResource
    {
        // Gets a Azure Active Directory administrator.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAAzureActiveDirectoryAdministrator()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/AdministratorGet.json
            // this example is just showing the usage of "ServerAzureADAdministrators_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerAzureADAdministratorResource created on azure
            // for more information of creating SqlServerAzureADAdministratorResource, please refer to the document of SqlServerAzureADAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string serverName = "sqlcrudtest-6440";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier sqlServerAzureADAdministratorResourceId = SqlServerAzureADAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, administratorName);
            SqlServerAzureADAdministratorResource sqlServerAzureADAdministrator = client.GetSqlServerAzureADAdministratorResource(sqlServerAzureADAdministratorResourceId);

            // invoke the operation
            SqlServerAzureADAdministratorResource result = await sqlServerAzureADAdministrator.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerAzureADAdministratorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates an existing Azure Active Directory administrator.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesAnExistingAzureActiveDirectoryAdministrator()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/AdministratorCreateOrUpdate.json
            // this example is just showing the usage of "ServerAzureADAdministrators_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerAzureADAdministratorResource created on azure
            // for more information of creating SqlServerAzureADAdministratorResource, please refer to the document of SqlServerAzureADAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string serverName = "sqlcrudtest-6440";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier sqlServerAzureADAdministratorResourceId = SqlServerAzureADAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, administratorName);
            SqlServerAzureADAdministratorResource sqlServerAzureADAdministrator = client.GetSqlServerAzureADAdministratorResource(sqlServerAzureADAdministratorResourceId);

            // invoke the operation
            SqlServerAzureADAdministratorData data = new SqlServerAzureADAdministratorData()
            {
                AdministratorType = SqlAdministratorType.ActiveDirectory,
                Login = "bob@contoso.com",
                Sid = Guid.Parse("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
                TenantId = Guid.Parse("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
            };
            ArmOperation<SqlServerAzureADAdministratorResource> lro = await sqlServerAzureADAdministrator.UpdateAsync(WaitUntil.Completed, data);
            SqlServerAzureADAdministratorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlServerAzureADAdministratorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Azure Active Directory administrator.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAzureActiveDirectoryAdministrator()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/AdministratorDelete.json
            // this example is just showing the usage of "ServerAzureADAdministrators_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlServerAzureADAdministratorResource created on azure
            // for more information of creating SqlServerAzureADAdministratorResource, please refer to the document of SqlServerAzureADAdministratorResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "sqlcrudtest-4799";
            string serverName = "sqlcrudtest-6440";
            SqlAdministratorName administratorName = SqlAdministratorName.ActiveDirectory;
            ResourceIdentifier sqlServerAzureADAdministratorResourceId = SqlServerAzureADAdministratorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, administratorName);
            SqlServerAzureADAdministratorResource sqlServerAzureADAdministrator = client.GetSqlServerAzureADAdministratorResource(sqlServerAzureADAdministratorResourceId);

            // invoke the operation
            await sqlServerAzureADAdministrator.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
