// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Sql.Samples
{
    public partial class Sample_SqlDatabaseTableCollection
    {
        // List  database tables
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDatabaseTables()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseTableListBySchema.json
            // this example is just showing the usage of "DatabaseTables_ListBySchema" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSchemaResource created on azure
            // for more information of creating SqlDatabaseSchemaResource, please refer to the document of SqlDatabaseSchemaResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string serverName = "serverName";
            string databaseName = "myDatabase";
            string schemaName = "dbo";
            ResourceIdentifier sqlDatabaseSchemaResourceId = SqlDatabaseSchemaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, schemaName);
            SqlDatabaseSchemaResource sqlDatabaseSchema = client.GetSqlDatabaseSchemaResource(sqlDatabaseSchemaResourceId);

            // get the collection of this SqlDatabaseTableResource
            SqlDatabaseTableCollection collection = sqlDatabaseSchema.GetSqlDatabaseTables();

            // invoke the operation and iterate over the result
            await foreach (SqlDatabaseTableResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DatabaseTableData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get database table
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDatabaseTable()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseTableGet.json
            // this example is just showing the usage of "DatabaseTables_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSchemaResource created on azure
            // for more information of creating SqlDatabaseSchemaResource, please refer to the document of SqlDatabaseSchemaResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string serverName = "serverName";
            string databaseName = "myDatabase";
            string schemaName = "dbo";
            ResourceIdentifier sqlDatabaseSchemaResourceId = SqlDatabaseSchemaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, schemaName);
            SqlDatabaseSchemaResource sqlDatabaseSchema = client.GetSqlDatabaseSchemaResource(sqlDatabaseSchemaResourceId);

            // get the collection of this SqlDatabaseTableResource
            SqlDatabaseTableCollection collection = sqlDatabaseSchema.GetSqlDatabaseTables();

            // invoke the operation
            string tableName = "table1";
            SqlDatabaseTableResource result = await collection.GetAsync(tableName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseTableData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get database table
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDatabaseTable()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseTableGet.json
            // this example is just showing the usage of "DatabaseTables_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSchemaResource created on azure
            // for more information of creating SqlDatabaseSchemaResource, please refer to the document of SqlDatabaseSchemaResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string serverName = "serverName";
            string databaseName = "myDatabase";
            string schemaName = "dbo";
            ResourceIdentifier sqlDatabaseSchemaResourceId = SqlDatabaseSchemaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, schemaName);
            SqlDatabaseSchemaResource sqlDatabaseSchema = client.GetSqlDatabaseSchemaResource(sqlDatabaseSchemaResourceId);

            // get the collection of this SqlDatabaseTableResource
            SqlDatabaseTableCollection collection = sqlDatabaseSchema.GetSqlDatabaseTables();

            // invoke the operation
            string tableName = "table1";
            bool result = await collection.ExistsAsync(tableName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get database table
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDatabaseTable()
        {
            // Generated from example definition: specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseTableGet.json
            // this example is just showing the usage of "DatabaseTables_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlDatabaseSchemaResource created on azure
            // for more information of creating SqlDatabaseSchemaResource, please refer to the document of SqlDatabaseSchemaResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "myRG";
            string serverName = "serverName";
            string databaseName = "myDatabase";
            string schemaName = "dbo";
            ResourceIdentifier sqlDatabaseSchemaResourceId = SqlDatabaseSchemaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName, databaseName, schemaName);
            SqlDatabaseSchemaResource sqlDatabaseSchema = client.GetSqlDatabaseSchemaResource(sqlDatabaseSchemaResourceId);

            // get the collection of this SqlDatabaseTableResource
            SqlDatabaseTableCollection collection = sqlDatabaseSchema.GetSqlDatabaseTables();

            // invoke the operation
            string tableName = "table1";
            NullableResponse<SqlDatabaseTableResource> response = await collection.GetIfExistsAsync(tableName);
            SqlDatabaseTableResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DatabaseTableData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
